@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azureactivedirectory.kotlin

import com.pulumi.azurenative.azureactivedirectory.kotlin.outputs.B2CResourceSKUResponse
import com.pulumi.azurenative.azureactivedirectory.kotlin.outputs.B2CTenantResourcePropertiesResponseBillingConfig
import com.pulumi.azurenative.azureactivedirectory.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.azureactivedirectory.kotlin.outputs.B2CResourceSKUResponse.Companion.toKotlin as b2CResourceSKUResponseToKotlin
import com.pulumi.azurenative.azureactivedirectory.kotlin.outputs.B2CTenantResourcePropertiesResponseBillingConfig.Companion.toKotlin as b2CTenantResourcePropertiesResponseBillingConfigToKotlin
import com.pulumi.azurenative.azureactivedirectory.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [B2CTenant].
 */
@PulumiTagMarker
public class B2CTenantResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: B2CTenantArgs = B2CTenantArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend B2CTenantArgsBuilder.() -> Unit) {
        val builder = B2CTenantArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): B2CTenant {
        val builtJavaResource =
            com.pulumi.azurenative.azureactivedirectory.B2CTenant(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return B2CTenant(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2021-04-01. Prior API version in Azure Native 1.x: 2019-01-01-preview.
 * Other available API versions: 2019-01-01-preview, 2023-01-18-preview, 2023-05-17-preview.
 * ## Example Usage
 * ### Create tenant
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var b2cTenant = new AzureNative.AzureActiveDirectory.B2CTenant("b2cTenant", new()
 *     {
 *         CountryCode = "US",
 *         DisplayName = "Contoso",
 *         Location = "United States",
 *         ResourceGroupName = "contosoResourceGroup",
 *         ResourceName = "contoso.onmicrosoft.com",
 *         Sku = new AzureNative.AzureActiveDirectory.Inputs.B2CResourceSKUArgs
 *         {
 *             Name = "Standard",
 *             Tier = "A0",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azureactivedirectory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azureactivedirectory.NewB2CTenant(ctx, "b2cTenant", &azureactivedirectory.B2CTenantArgs{
 * 			CountryCode:       pulumi.String("US"),
 * 			DisplayName:       pulumi.String("Contoso"),
 * 			Location:          pulumi.String("United States"),
 * 			ResourceGroupName: pulumi.String("contosoResourceGroup"),
 * 			ResourceName:      pulumi.String("contoso.onmicrosoft.com"),
 * 			Sku: &azureactivedirectory.B2CResourceSKUArgs{
 * 				Name: pulumi.String("Standard"),
 * 				Tier: pulumi.String("A0"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azureactivedirectory.B2CTenant;
 * import com.pulumi.azurenative.azureactivedirectory.B2CTenantArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var b2cTenant = new B2CTenant("b2cTenant", B2CTenantArgs.builder()
 *             .countryCode("US")
 *             .displayName("Contoso")
 *             .location("United States")
 *             .resourceGroupName("contosoResourceGroup")
 *             .resourceName("contoso.onmicrosoft.com")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Standard"),
 *                 Map.entry("tier", "A0")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azureactivedirectory:B2CTenant contoso.onmicrosoft.com /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureActiveDirectory/b2cDirectories/{resourceName}
 * ```
 */
public class B2CTenant internal constructor(
    override val javaResource: com.pulumi.azurenative.azureactivedirectory.B2CTenant,
) : KotlinCustomResource(javaResource, B2CTenantMapper) {
    /**
     * The billing configuration for the tenant.
     */
    public val billingConfig: Output<B2CTenantResourcePropertiesResponseBillingConfig>?
        get() = javaResource.billingConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    b2CTenantResourcePropertiesResponseBillingConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The location in which the resource is hosted and data resides. Can be one of 'United States', 'Europe', 'Asia Pacific', or 'Australia'. Refer to [this documentation](https://aka.ms/B2CDataResidency) for more information.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the Azure AD B2C tenant resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * SKU properties of the Azure AD B2C tenant. Learn more about Azure AD B2C billing at [aka&#46;ms/b2cBilling](https://aka.ms/b2cBilling).
     */
    public val sku: Output<B2CResourceSKUResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                b2CResourceSKUResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource Tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * An identifier of the Azure AD B2C tenant.
     */
    public val tenantId: Output<String>?
        get() = javaResource.tenantId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the B2C tenant resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object B2CTenantMapper : ResourceMapper<B2CTenant> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azureactivedirectory.B2CTenant::class == javaResource::class

    override fun map(javaResource: Resource): B2CTenant = B2CTenant(
        javaResource as
            com.pulumi.azurenative.azureactivedirectory.B2CTenant,
    )
}

/**
 * @see [B2CTenant].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [B2CTenant].
 */
public suspend fun b2cTenant(name: String, block: suspend B2CTenantResourceBuilder.() -> Unit):
    B2CTenant {
    val builder = B2CTenantResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [B2CTenant].
 * @param name The _unique_ name of the resulting resource.
 */
public fun b2cTenant(name: String): B2CTenant {
    val builder = B2CTenantResourceBuilder()
    builder.name(name)
    return builder.build()
}
