@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azureactivedirectory.kotlin

import com.pulumi.azurenative.azureactivedirectory.GuestUsageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Guest Usages Resource
 * Azure REST API version: 2021-04-01. Prior API version in Azure Native 1.x: 2020-05-01-preview.
 * Other available API versions: 2023-01-18-preview, 2023-05-17-preview.
 * ## Example Usage
 * ### GuestUsages_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var guestUsage = new AzureNative.AzureActiveDirectory.GuestUsage("guestUsage", new()
 *     {
 *         ResourceGroupName = "contosoResourceGroup",
 *         ResourceName = "contoso.onmicrosoft.com",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azureactivedirectory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azureactivedirectory.NewGuestUsage(ctx, "guestUsage", &azureactivedirectory.GuestUsageArgs{
 * 			ResourceGroupName: pulumi.String("contosoResourceGroup"),
 * 			ResourceName:      pulumi.String("contoso.onmicrosoft.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azureactivedirectory.GuestUsage;
 * import com.pulumi.azurenative.azureactivedirectory.GuestUsageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var guestUsage = new GuestUsage("guestUsage", GuestUsageArgs.builder()
 *             .resourceGroupName("contosoResourceGroup")
 *             .resourceName("contoso.onmicrosoft.com")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azureactivedirectory:GuestUsage contoso.onmicrosoft.com /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureActiveDirectory/guestUsages/{resourceName}
 * ```
 * @property location Location of the Guest Usages resource.
 * @property resourceGroupName The name of the resource group.
 * @property resourceName The initial domain name of the Azure AD B2C tenant.
 * @property tags Key-value pairs of additional resource provisioning properties.
 * @property tenantId An identifier for the tenant for which the resource is being created
 */
public data class GuestUsageArgs(
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azureactivedirectory.GuestUsageArgs> {
    override fun toJava(): com.pulumi.azurenative.azureactivedirectory.GuestUsageArgs =
        com.pulumi.azurenative.azureactivedirectory.GuestUsageArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GuestUsageArgs].
 */
@PulumiTagMarker
public class GuestUsageArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value Location of the Guest Usages resource.
     */
    @JvmName("ogsxpqufugqhuiay")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("spuowrtfqgxxcxtu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The initial domain name of the Azure AD B2C tenant.
     */
    @JvmName("haylkeafioepaxge")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Key-value pairs of additional resource provisioning properties.
     */
    @JvmName("usmmelgqxdxkiwso")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value An identifier for the tenant for which the resource is being created
     */
    @JvmName("lekdwfgxubqmyhpw")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Location of the Guest Usages resource.
     */
    @JvmName("gkoambwrmqbsjgeo")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vvuqrhineaqivesh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The initial domain name of the Azure AD B2C tenant.
     */
    @JvmName("plibrgsjkswiygfv")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Key-value pairs of additional resource provisioning properties.
     */
    @JvmName("uvcxvskaaququhkx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value pairs of additional resource provisioning properties.
     */
    @JvmName("luyjdeqneqpewvsn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value An identifier for the tenant for which the resource is being created
     */
    @JvmName("abxrpvxqhkdthbkp")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): GuestUsageArgs = GuestUsageArgs(
        location = location,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        tags = tags,
        tenantId = tenantId,
    )
}
