@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azureactivedirectory.kotlin.inputs

import com.pulumi.azurenative.azureactivedirectory.inputs.CreateCIAMTenantPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * These properties are used to create the Azure AD for customers tenant. These properties are not part of the Azure resource.
 * @property countryCode Country code of Azure tenant (e.g. 'US'). Refer to [https://aka&#46;ms/ciam-data-location](https://aka.ms/ciam-data-location) to see valid country codes and corresponding data residency locations. If you do not see a country code in an valid data residency location, choose one from the list.
 * @property displayName The display name of the Azure AD for customers tenant.
 */
public data class CreateCIAMTenantPropertiesArgs(
    public val countryCode: Output<String>,
    public val displayName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.azureactivedirectory.inputs.CreateCIAMTenantPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.azureactivedirectory.inputs.CreateCIAMTenantPropertiesArgs =
        com.pulumi.azurenative.azureactivedirectory.inputs.CreateCIAMTenantPropertiesArgs.builder()
            .countryCode(countryCode.applyValue({ args0 -> args0 }))
            .displayName(displayName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CreateCIAMTenantPropertiesArgs].
 */
@PulumiTagMarker
public class CreateCIAMTenantPropertiesArgsBuilder internal constructor() {
    private var countryCode: Output<String>? = null

    private var displayName: Output<String>? = null

    /**
     * @param value Country code of Azure tenant (e.g. 'US'). Refer to [https://aka&#46;ms/ciam-data-location](https://aka.ms/ciam-data-location) to see valid country codes and corresponding data residency locations. If you do not see a country code in an valid data residency location, choose one from the list.
     */
    @JvmName("mjlcmvwahjdvoyop")
    public suspend fun countryCode(`value`: Output<String>) {
        this.countryCode = value
    }

    /**
     * @param value The display name of the Azure AD for customers tenant.
     */
    @JvmName("vbtrpjvhamcuqmep")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Country code of Azure tenant (e.g. 'US'). Refer to [https://aka&#46;ms/ciam-data-location](https://aka.ms/ciam-data-location) to see valid country codes and corresponding data residency locations. If you do not see a country code in an valid data residency location, choose one from the list.
     */
    @JvmName("srutnocdukvhymdn")
    public suspend fun countryCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.countryCode = mapped
    }

    /**
     * @param value The display name of the Azure AD for customers tenant.
     */
    @JvmName("xmtbccgtcupokbet")
    public suspend fun displayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    internal fun build(): CreateCIAMTenantPropertiesArgs = CreateCIAMTenantPropertiesArgs(
        countryCode = countryCode ?: throw PulumiNullFieldException("countryCode"),
        displayName = displayName ?: throw PulumiNullFieldException("displayName"),
    )
}
