@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin

import com.pulumi.azurenative.azurearcdata.kotlin.outputs.DataControllerPropertiesResponse
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.DataControllerPropertiesResponse.Companion.toKotlin as dataControllerPropertiesResponseToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DataController].
 */
@PulumiTagMarker
public class DataControllerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataControllerArgs = DataControllerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataControllerArgsBuilder.() -> Unit) {
        val builder = DataControllerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DataController {
        val builtJavaResource =
            com.pulumi.azurenative.azurearcdata.DataController(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DataController(builtJavaResource)
    }
}

/**
 * Data controller resource
 * Azure REST API version: 2023-01-15-preview. Prior API version in Azure Native 1.x: 2021-06-01-preview.
 * ## Example Usage
 * ### Create or update a Data Controller.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataController = new AzureNative.AzureArcData.DataController("dataController", new()
 *     {
 *         DataControllerName = "testdataController",
 *         ExtendedLocation = new AzureNative.AzureArcData.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.ExtendedLocation/customLocations/arclocation",
 *             Type = "CustomLocation",
 *         },
 *         Location = "northeurope",
 *         Properties = new AzureNative.AzureArcData.Inputs.DataControllerPropertiesArgs
 *         {
 *             BasicLoginInformation = new AzureNative.AzureArcData.Inputs.BasicLoginInformationArgs
 *             {
 *                 Password = "********",
 *                 Username = "username",
 *             },
 *             ClusterId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/connectedk8s",
 *             ExtensionId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/connectedk8s/providers/Microsoft.KubernetesConfiguration/extensions/extension",
 *             Infrastructure = AzureNative.AzureArcData.Infrastructure.Onpremises,
 *             LogAnalyticsWorkspaceConfig = new AzureNative.AzureArcData.Inputs.LogAnalyticsWorkspaceConfigArgs
 *             {
 *                 PrimaryKey = "********",
 *                 WorkspaceId = "00000000-1111-2222-3333-444444444444",
 *             },
 *             LogsDashboardCredential = new AzureNative.AzureArcData.Inputs.BasicLoginInformationArgs
 *             {
 *                 Password = "********",
 *                 Username = "username",
 *             },
 *             MetricsDashboardCredential = new AzureNative.AzureArcData.Inputs.BasicLoginInformationArgs
 *             {
 *                 Password = "********",
 *                 Username = "username",
 *             },
 *             OnPremiseProperty = new AzureNative.AzureArcData.Inputs.OnPremisePropertyArgs
 *             {
 *                 Id = "12345678-1234-1234-ab12-1a2b3c4d5e6f",
 *                 PublicSigningKey = "publicOnPremSigningKey",
 *             },
 *             UploadServicePrincipal = new AzureNative.AzureArcData.Inputs.UploadServicePrincipalArgs
 *             {
 *                 Authority = "https://login.microsoftonline.com/",
 *                 ClientId = "00000000-1111-2222-3333-444444444444",
 *                 ClientSecret = "********",
 *                 TenantId = "00000000-1111-2222-3333-444444444444",
 *             },
 *             UploadWatermark = new AzureNative.AzureArcData.Inputs.UploadWatermarkArgs
 *             {
 *                 Logs = "2020-01-01T17:18:19.1234567Z",
 *                 Metrics = "2020-01-01T17:18:19.1234567Z",
 *                 Usages = "2020-01-01T17:18:19.1234567Z",
 *             },
 *         },
 *         ResourceGroupName = "testrg",
 *         Tags =
 *         {
 *             { "mytag", "myval" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurearcdata/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurearcdata.NewDataController(ctx, "dataController", &azurearcdata.DataControllerArgs{
 * 			DataControllerName: pulumi.String("testdataController"),
 * 			ExtendedLocation: &azurearcdata.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.ExtendedLocation/customLocations/arclocation"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location: pulumi.String("northeurope"),
 * 			Properties: azurearcdata.DataControllerPropertiesResponse{
 * 				BasicLoginInformation: &azurearcdata.BasicLoginInformationArgs{
 * 					Password: pulumi.String("********"),
 * 					Username: pulumi.String("username"),
 * 				},
 * 				ClusterId:      pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/connectedk8s"),
 * 				ExtensionId:    pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/connectedk8s/providers/Microsoft.KubernetesConfiguration/extensions/extension"),
 * 				Infrastructure: azurearcdata.InfrastructureOnpremises,
 * 				LogAnalyticsWorkspaceConfig: &azurearcdata.LogAnalyticsWorkspaceConfigArgs{
 * 					PrimaryKey:  pulumi.String("********"),
 * 					WorkspaceId: pulumi.String("00000000-1111-2222-3333-444444444444"),
 * 				},
 * 				LogsDashboardCredential: &azurearcdata.BasicLoginInformationArgs{
 * 					Password: pulumi.String("********"),
 * 					Username: pulumi.String("username"),
 * 				},
 * 				MetricsDashboardCredential: &azurearcdata.BasicLoginInformationArgs{
 * 					Password: pulumi.String("********"),
 * 					Username: pulumi.String("username"),
 * 				},
 * 				OnPremiseProperty: &azurearcdata.OnPremisePropertyArgs{
 * 					Id:               pulumi.String("12345678-1234-1234-ab12-1a2b3c4d5e6f"),
 * 					PublicSigningKey: pulumi.String("publicOnPremSigningKey"),
 * 				},
 * 				UploadServicePrincipal: &azurearcdata.UploadServicePrincipalArgs{
 * 					Authority:    pulumi.String("https://login.microsoftonline.com/"),
 * 					ClientId:     pulumi.String("00000000-1111-2222-3333-444444444444"),
 * 					ClientSecret: pulumi.String("********"),
 * 					TenantId:     pulumi.String("00000000-1111-2222-3333-444444444444"),
 * 				},
 * 				UploadWatermark: &azurearcdata.UploadWatermarkArgs{
 * 					Logs:    pulumi.String("2020-01-01T17:18:19.1234567Z"),
 * 					Metrics: pulumi.String("2020-01-01T17:18:19.1234567Z"),
 * 					Usages:  pulumi.String("2020-01-01T17:18:19.1234567Z"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			Tags: pulumi.StringMap{
 * 				"mytag": pulumi.String("myval"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurearcdata.DataController;
 * import com.pulumi.azurenative.azurearcdata.DataControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataController = new DataController("dataController", DataControllerArgs.builder()
 *             .dataControllerName("testdataController")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.ExtendedLocation/customLocations/arclocation"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .location("northeurope")
 *             .properties(Map.ofEntries(
 *                 Map.entry("basicLoginInformation", Map.ofEntries(
 *                     Map.entry("password", "********"),
 *                     Map.entry("username", "username")
 *                 )),
 *                 Map.entry("clusterId", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/connectedk8s"),
 *                 Map.entry("extensionId", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/connectedk8s/providers/Microsoft.KubernetesConfiguration/extensions/extension"),
 *                 Map.entry("infrastructure", "onpremises"),
 *                 Map.entry("logAnalyticsWorkspaceConfig", Map.ofEntries(
 *                     Map.entry("primaryKey", "********"),
 *                     Map.entry("workspaceId", "00000000-1111-2222-3333-444444444444")
 *                 )),
 *                 Map.entry("logsDashboardCredential", Map.ofEntries(
 *                     Map.entry("password", "********"),
 *                     Map.entry("username", "username")
 *                 )),
 *                 Map.entry("metricsDashboardCredential", Map.ofEntries(
 *                     Map.entry("password", "********"),
 *                     Map.entry("username", "username")
 *                 )),
 *                 Map.entry("onPremiseProperty", Map.ofEntries(
 *                     Map.entry("id", "12345678-1234-1234-ab12-1a2b3c4d5e6f"),
 *                     Map.entry("publicSigningKey", "publicOnPremSigningKey")
 *                 )),
 *                 Map.entry("uploadServicePrincipal", Map.ofEntries(
 *                     Map.entry("authority", "https://login.microsoftonline.com/"),
 *                     Map.entry("clientId", "00000000-1111-2222-3333-444444444444"),
 *                     Map.entry("clientSecret", "********"),
 *                     Map.entry("tenantId", "00000000-1111-2222-3333-444444444444")
 *                 )),
 *                 Map.entry("uploadWatermark", Map.ofEntries(
 *                     Map.entry("logs", "2020-01-01T17:18:19.1234567Z"),
 *                     Map.entry("metrics", "2020-01-01T17:18:19.1234567Z"),
 *                     Map.entry("usages", "2020-01-01T17:18:19.1234567Z")
 *                 ))
 *             ))
 *             .resourceGroupName("testrg")
 *             .tags(Map.of("mytag", "myval"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurearcdata:DataController testdataController /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureArcData/dataControllers/{dataControllerName}
 * ```
 */
public class DataController internal constructor(
    override val javaResource: com.pulumi.azurenative.azurearcdata.DataController,
) : KotlinCustomResource(javaResource, DataControllerMapper) {
    /**
     * The extendedLocation of the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The data controller's properties
     */
    public val properties: Output<DataControllerPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                dataControllerPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DataControllerMapper : ResourceMapper<DataController> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azurearcdata.DataController::class == javaResource::class

    override fun map(javaResource: Resource): DataController = DataController(
        javaResource as
            com.pulumi.azurenative.azurearcdata.DataController,
    )
}

/**
 * @see [DataController].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataController].
 */
public suspend fun dataController(
    name: String,
    block: suspend DataControllerResourceBuilder.() -> Unit,
): DataController {
    val builder = DataControllerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataController].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataController(name: String): DataController {
    val builder = DataControllerResourceBuilder()
    builder.name(name)
    return builder.build()
}
