@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin

import com.pulumi.azurenative.azurearcdata.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.PostgresInstancePropertiesResponse
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.PostgresInstanceSkuResponse
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.PostgresInstancePropertiesResponse.Companion.toKotlin as postgresInstancePropertiesResponseToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.PostgresInstanceSkuResponse.Companion.toKotlin as postgresInstanceSkuResponseToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PostgresInstance].
 */
@PulumiTagMarker
public class PostgresInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PostgresInstanceArgs = PostgresInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PostgresInstanceArgsBuilder.() -> Unit) {
        val builder = PostgresInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PostgresInstance {
        val builtJavaResource =
            com.pulumi.azurenative.azurearcdata.PostgresInstance(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PostgresInstance(builtJavaResource)
    }
}

/**
 * A Postgres Instance.
 * Azure REST API version: 2023-01-15-preview. Prior API version in Azure Native 1.x: 2021-06-01-preview.
 * ## Example Usage
 * ### Create or update a Postgres Instance.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var postgresInstance = new AzureNative.AzureArcData.PostgresInstance("postgresInstance", new()
 *     {
 *         ExtendedLocation = new AzureNative.AzureArcData.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.ExtendedLocation/customLocations/arclocation",
 *             Type = "CustomLocation",
 *         },
 *         Location = "eastus",
 *         PostgresInstanceName = "testpostgresInstance",
 *         Properties = new AzureNative.AzureArcData.Inputs.PostgresInstancePropertiesArgs
 *         {
 *             Admin = "admin",
 *             BasicLoginInformation = new AzureNative.AzureArcData.Inputs.BasicLoginInformationArgs
 *             {
 *                 Password = "********",
 *                 Username = "username",
 *             },
 *             DataControllerId = "dataControllerId",
 *             K8sRaw =
 *             {
 *                 { "apiVersion", "apiVersion" },
 *                 { "kind", "postgresql-12" },
 *                 { "metadata",
 *                 {
 *                     { "creationTimestamp", "2020-08-25T14:55:10Z" },
 *                     { "generation", 1 },
 *                     { "name", "pg1" },
 *                     { "namespace", "test" },
 *                     { "resourceVersion", "527780" },
 *                     { "selfLink", "/apis/arcdata.microsoft.com/v1alpha1/namespaces/test/postgresql-12s/pg1" },
 *                     { "uid", "1111aaaa-ffff-ffff-ffff-99999aaaaaaa" },
 *                 } },
 *                 { "spec",
 *                 {
 *                     { "backups",
 *                     {
 *                         { "deltaMinutes", 3 },
 *                         { "fullMinutes", 10 },
 *                         { "tiers", new[]
 *                         {
 *                             {
 *                                 { "retention",
 *                                 {
 *                                     { "maximums", new[]
 *                                     {
 *                                         "6",
 *                                         "512MB",
 *                                     } },
 *                                     { "minimums", new[]
 *                                     {
 *                                         "3",
 *                                     } },
 *                                 } },
 *                                 { "storage",
 *                                 {
 *                                     { "volumeSize", "1Gi" },
 *                                 } },
 *                             },
 *                         } },
 *                     } },
 *                     { "engine",
 *                     {
 *                         { "extensions", new[]
 *                         {
 *                             {
 *                                 { "name", "citus" },
 *                             },
 *                         } },
 *                     } },
 *                     { "scale",
 *                     {
 *                         { "shards", 3 },
 *                     } },
 *                     { "scheduling",
 *                     {
 *                         { "default",
 *                         {
 *                             { "resources",
 *                             {
 *                                 { "requests",
 *                                 {
 *                                     { "memory", "256Mi" },
 *                                 } },
 *                             } },
 *                         } },
 *                     } },
 *                     { "service",
 *                     {
 *                         { "type", "NodePort" },
 *                     } },
 *                     { "storage",
 *                     {
 *                         { "data",
 *                         {
 *                             { "className", "local-storage" },
 *                             { "size", "5Gi" },
 *                         } },
 *                         { "logs",
 *                         {
 *                             { "className", "local-storage" },
 *                             { "size", "5Gi" },
 *                         } },
 *                     } },
 *                 } },
 *                 { "status",
 *                 {
 *                     { "externalEndpoint", null },
 *                     { "readyPods", "4/4" },
 *                     { "state", "Ready" },
 *                 } },
 *             },
 *         },
 *         ResourceGroupName = "testrg",
 *         Sku = new AzureNative.AzureArcData.Inputs.PostgresInstanceSkuArgs
 *         {
 *             Dev = true,
 *             Name = "default",
 *             Tier = AzureNative.AzureArcData.PostgresInstanceSkuTier.Hyperscale,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurearcdata/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurearcdata.NewPostgresInstance(ctx, "postgresInstance", &azurearcdata.PostgresInstanceArgs{
 * 			ExtendedLocation: &azurearcdata.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.ExtendedLocation/customLocations/arclocation"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location:             pulumi.String("eastus"),
 * 			PostgresInstanceName: pulumi.String("testpostgresInstance"),
 * 			Properties: azurearcdata.PostgresInstancePropertiesResponse{
 * 				Admin: pulumi.String("admin"),
 * 				BasicLoginInformation: &azurearcdata.BasicLoginInformationArgs{
 * 					Password: pulumi.String("********"),
 * 					Username: pulumi.String("username"),
 * 				},
 * 				DataControllerId: pulumi.String("dataControllerId"),
 * 				K8sRaw: pulumi.Any{
 * 					ApiVersion: "apiVersion",
 * 					Kind:       "postgresql-12",
 * 					Metadata: map[string]interface{}{
 * 						"creationTimestamp": "2020-08-25T14:55:10Z",
 * 						"generation":        1,
 * 						"name":              "pg1",
 * 						"namespace":         "test",
 * 						"resourceVersion":   "527780",
 * 						"selfLink":          "/apis/arcdata.microsoft.com/v1alpha1/namespaces/test/postgresql-12s/pg1",
 * 						"uid":               "1111aaaa-ffff-ffff-ffff-99999aaaaaaa",
 * 					},
 * 					Spec: map[string]interface{}{
 * 						"backups": map[string]interface{}{
 * 							"deltaMinutes": 3,
 * 							"fullMinutes":  10,
 * 							"tiers": []map[string]interface{}{
 * 								map[string]interface{}{
 * 									"retention": map[string]interface{}{
 * 										"maximums": []string{
 * 											"6",
 * 											"512MB",
 * 										},
 * 										"minimums": []string{
 * 											"3",
 * 										},
 * 									},
 * 									"storage": map[string]interface{}{
 * 										"volumeSize": "1Gi",
 * 									},
 * 								},
 * 							},
 * 						},
 * 						"engine": map[string]interface{}{
 * 							"extensions": []map[string]interface{}{
 * 								map[string]interface{}{
 * 									"name": "citus",
 * 								},
 * 							},
 * 						},
 * 						"scale": map[string]interface{}{
 * 							"shards": 3,
 * 						},
 * 						"scheduling": map[string]interface{}{
 * 							"default": map[string]interface{}{
 * 								"resources": map[string]interface{}{
 * 									"requests": map[string]interface{}{
 * 										"memory": "256Mi",
 * 									},
 * 								},
 * 							},
 * 						},
 * 						"service": map[string]interface{}{
 * 							"type": "NodePort",
 * 						},
 * 						"storage": map[string]interface{}{
 * 							"data": map[string]interface{}{
 * 								"className": "local-storage",
 * 								"size":      "5Gi",
 * 							},
 * 							"logs": map[string]interface{}{
 * 								"className": "local-storage",
 * 								"size":      "5Gi",
 * 							},
 * 						},
 * 					},
 * 					Status: map[string]interface{}{
 * 						"externalEndpoint": nil,
 * 						"readyPods":        "4/4",
 * 						"state":            "Ready",
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			Sku: &azurearcdata.PostgresInstanceSkuArgs{
 * 				Dev:  pulumi.Bool(true),
 * 				Name: pulumi.String("default"),
 * 				Tier: azurearcdata.PostgresInstanceSkuTierHyperscale,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurearcdata.PostgresInstance;
 * import com.pulumi.azurenative.azurearcdata.PostgresInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var postgresInstance = new PostgresInstance("postgresInstance", PostgresInstanceArgs.builder()
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.ExtendedLocation/customLocations/arclocation"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .location("eastus")
 *             .postgresInstanceName("testpostgresInstance")
 *             .properties(Map.ofEntries(
 *                 Map.entry("admin", "admin"),
 *                 Map.entry("basicLoginInformation", Map.ofEntries(
 *                     Map.entry("password", "********"),
 *                     Map.entry("username", "username")
 *                 )),
 *                 Map.entry("dataControllerId", "dataControllerId"),
 *                 Map.entry("k8sRaw", Map.ofEntries(
 *                     Map.entry("apiVersion", "apiVersion"),
 *                     Map.entry("kind", "postgresql-12"),
 *                     Map.entry("metadata", PostgresInstancePropertiesArgs.builder()
 *                         .creationTimestamp("2020-08-25T14:55:10Z")
 *                         .generation(1)
 *                         .name("pg1")
 *                         .namespace("test")
 *                         .resourceVersion("527780")
 *                         .selfLink("/apis/arcdata.microsoft.com/v1alpha1/namespaces/test/postgresql-12s/pg1")
 *                         .uid("1111aaaa-ffff-ffff-ffff-99999aaaaaaa")
 *                         .build()),
 *                     Map.entry("spec", PostgresInstancePropertiesArgs.builder()
 *                         .backups(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                         .engine(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                         .scale(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                         .scheduling(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                         .service(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                         .storage(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                         .build()),
 *                     Map.entry("status", PostgresInstancePropertiesArgs.builder()
 *                         .externalEndpoint(null)
 *                         .readyPods("4/4")
 *                         .state("Ready")
 *                         .build())
 *                 ))
 *             ))
 *             .resourceGroupName("testrg")
 *             .sku(Map.ofEntries(
 *                 Map.entry("dev", true),
 *                 Map.entry("name", "default"),
 *                 Map.entry("tier", "Hyperscale")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurearcdata:PostgresInstance testpostgresInstance /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureArcData/postgresInstances/{postgresInstanceName}
 * ```
 */
public class PostgresInstance internal constructor(
    override val javaResource: com.pulumi.azurenative.azurearcdata.PostgresInstance,
) : KotlinCustomResource(javaResource, PostgresInstanceMapper) {
    /**
     * The extendedLocation of the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * null
     */
    public val properties: Output<PostgresInstancePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                postgresInstancePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Resource sku.
     */
    public val sku: Output<PostgresInstanceSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    postgresInstanceSkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PostgresInstanceMapper : ResourceMapper<PostgresInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azurearcdata.PostgresInstance::class == javaResource::class

    override fun map(javaResource: Resource): PostgresInstance = PostgresInstance(
        javaResource as
            com.pulumi.azurenative.azurearcdata.PostgresInstance,
    )
}

/**
 * @see [PostgresInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PostgresInstance].
 */
public suspend fun postgresInstance(
    name: String,
    block: suspend PostgresInstanceResourceBuilder.() -> Unit,
): PostgresInstance {
    val builder = PostgresInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PostgresInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun postgresInstance(name: String): PostgresInstance {
    val builder = PostgresInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
