@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin

import com.pulumi.azurenative.azurearcdata.kotlin.outputs.SqlServerDatabaseResourcePropertiesResponse
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.SqlServerDatabaseResourcePropertiesResponse.Companion.toKotlin as sqlServerDatabaseResourcePropertiesResponseToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [SqlServerDatabase].
 */
@PulumiTagMarker
public class SqlServerDatabaseResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SqlServerDatabaseArgs = SqlServerDatabaseArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SqlServerDatabaseArgsBuilder.() -> Unit) {
        val builder = SqlServerDatabaseArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SqlServerDatabase {
        val builtJavaResource =
            com.pulumi.azurenative.azurearcdata.SqlServerDatabase(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SqlServerDatabase(builtJavaResource)
    }
}

/**
 * Arc Sql Server database
 * Azure REST API version: 2023-01-15-preview.
 * ## Example Usage
 * ### Create a Arc Sql Server database.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlServerDatabase = new AzureNative.AzureArcData.SqlServerDatabase("sqlServerDatabase", new()
 *     {
 *         DatabaseName = "testdb",
 *         Location = "southeastasia",
 *         Properties = new AzureNative.AzureArcData.Inputs.SqlServerDatabaseResourcePropertiesArgs
 *         {
 *             BackupInformation = new AzureNative.AzureArcData.Inputs.SqlServerDatabaseResourcePropertiesBackupInformationArgs
 *             {
 *                 LastFullBackup = "2022-05-05T16:26:33.883Z",
 *                 LastLogBackup = "2022-05-10T16:26:33.883Z",
 *             },
 *             CollationName = "SQL_Latin1_General_CP1_CI_AS",
 *             CompatibilityLevel = 150,
 *             DatabaseCreationDate = "2022-04-05T16:26:33.883Z",
 *             DatabaseOptions = new AzureNative.AzureArcData.Inputs.SqlServerDatabaseResourcePropertiesDatabaseOptionsArgs
 *             {
 *                 IsAutoCloseOn = true,
 *                 IsAutoCreateStatsOn = true,
 *                 IsAutoShrinkOn = true,
 *                 IsAutoUpdateStatsOn = true,
 *                 IsEncrypted = true,
 *                 IsMemoryOptimizationEnabled = true,
 *                 IsRemoteDataArchiveEnabled = true,
 *                 IsTrustworthyOn = true,
 *             },
 *             IsReadOnly = true,
 *             RecoveryMode = "Full",
 *             SizeMB = 150,
 *             SpaceAvailableMB = 100,
 *             State = "Online",
 *         },
 *         ResourceGroupName = "testrg",
 *         SqlServerInstanceName = "testSqlServerInstance",
 *         Tags =
 *         {
 *             { "mytag", "myval" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurearcdata/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurearcdata.NewSqlServerDatabase(ctx, "sqlServerDatabase", &azurearcdata.SqlServerDatabaseArgs{
 * 			DatabaseName: pulumi.String("testdb"),
 * 			Location:     pulumi.String("southeastasia"),
 * 			Properties: azurearcdata.SqlServerDatabaseResourcePropertiesResponse{
 * 				BackupInformation: &azurearcdata.SqlServerDatabaseResourcePropertiesBackupInformationArgs{
 * 					LastFullBackup: pulumi.String("2022-05-05T16:26:33.883Z"),
 * 					LastLogBackup:  pulumi.String("2022-05-10T16:26:33.883Z"),
 * 				},
 * 				CollationName:        pulumi.String("SQL_Latin1_General_CP1_CI_AS"),
 * 				CompatibilityLevel:   pulumi.Int(150),
 * 				DatabaseCreationDate: pulumi.String("2022-04-05T16:26:33.883Z"),
 * 				DatabaseOptions: &azurearcdata.SqlServerDatabaseResourcePropertiesDatabaseOptionsArgs{
 * 					IsAutoCloseOn:               pulumi.Bool(true),
 * 					IsAutoCreateStatsOn:         pulumi.Bool(true),
 * 					IsAutoShrinkOn:              pulumi.Bool(true),
 * 					IsAutoUpdateStatsOn:         pulumi.Bool(true),
 * 					IsEncrypted:                 pulumi.Bool(true),
 * 					IsMemoryOptimizationEnabled: pulumi.Bool(true),
 * 					IsRemoteDataArchiveEnabled:  pulumi.Bool(true),
 * 					IsTrustworthyOn:             pulumi.Bool(true),
 * 				},
 * 				IsReadOnly:       pulumi.Bool(true),
 * 				RecoveryMode:     pulumi.String("Full"),
 * 				SizeMB:           pulumi.Float64(150),
 * 				SpaceAvailableMB: pulumi.Float64(100),
 * 				State:            pulumi.String("Online"),
 * 			},
 * 			ResourceGroupName:     pulumi.String("testrg"),
 * 			SqlServerInstanceName: pulumi.String("testSqlServerInstance"),
 * 			Tags: pulumi.StringMap{
 * 				"mytag": pulumi.String("myval"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurearcdata.SqlServerDatabase;
 * import com.pulumi.azurenative.azurearcdata.SqlServerDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlServerDatabase = new SqlServerDatabase("sqlServerDatabase", SqlServerDatabaseArgs.builder()
 *             .databaseName("testdb")
 *             .location("southeastasia")
 *             .properties(Map.ofEntries(
 *                 Map.entry("backupInformation", Map.ofEntries(
 *                     Map.entry("lastFullBackup", "2022-05-05T16:26:33.883Z"),
 *                     Map.entry("lastLogBackup", "2022-05-10T16:26:33.883Z")
 *                 )),
 *                 Map.entry("collationName", "SQL_Latin1_General_CP1_CI_AS"),
 *                 Map.entry("compatibilityLevel", 150),
 *                 Map.entry("databaseCreationDate", "2022-04-05T16:26:33.883Z"),
 *                 Map.entry("databaseOptions", Map.ofEntries(
 *                     Map.entry("isAutoCloseOn", true),
 *                     Map.entry("isAutoCreateStatsOn", true),
 *                     Map.entry("isAutoShrinkOn", true),
 *                     Map.entry("isAutoUpdateStatsOn", true),
 *                     Map.entry("isEncrypted", true),
 *                     Map.entry("isMemoryOptimizationEnabled", true),
 *                     Map.entry("isRemoteDataArchiveEnabled", true),
 *                     Map.entry("isTrustworthyOn", true)
 *                 )),
 *                 Map.entry("isReadOnly", true),
 *                 Map.entry("recoveryMode", "Full"),
 *                 Map.entry("sizeMB", 150),
 *                 Map.entry("spaceAvailableMB", 100),
 *                 Map.entry("state", "Online")
 *             ))
 *             .resourceGroupName("testrg")
 *             .sqlServerInstanceName("testSqlServerInstance")
 *             .tags(Map.of("mytag", "myval"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurearcdata:SqlServerDatabase testdb /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureArcData/sqlServerInstances/{sqlServerInstanceName}/databases/{databaseName}
 * ```
 */
public class SqlServerDatabase internal constructor(
    override val javaResource: com.pulumi.azurenative.azurearcdata.SqlServerDatabase,
) : KotlinCustomResource(javaResource, SqlServerDatabaseMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of Arc Sql Server database
     */
    public val properties: Output<SqlServerDatabaseResourcePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                sqlServerDatabaseResourcePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SqlServerDatabaseMapper : ResourceMapper<SqlServerDatabase> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azurearcdata.SqlServerDatabase::class == javaResource::class

    override fun map(javaResource: Resource): SqlServerDatabase = SqlServerDatabase(
        javaResource as
            com.pulumi.azurenative.azurearcdata.SqlServerDatabase,
    )
}

/**
 * @see [SqlServerDatabase].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SqlServerDatabase].
 */
public suspend fun sqlServerDatabase(
    name: String,
    block: suspend SqlServerDatabaseResourceBuilder.() -> Unit,
): SqlServerDatabase {
    val builder = SqlServerDatabaseResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SqlServerDatabase].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sqlServerDatabase(name: String): SqlServerDatabase {
    val builder = SqlServerDatabaseResourceBuilder()
    builder.name(name)
    return builder.build()
}
