@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryConnectorDomainDetailsArgs.builder
import com.pulumi.azurenative.azurearcdata.kotlin.enums.AccountProvisioningMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Active Directory domain details
 * @property domainControllers null
 * @property netbiosDomainName NETBIOS name of the Active Directory domain.
 * @property ouDistinguishedName The distinguished name of the Active Directory Organizational Unit.
 * @property realm Name (uppercase) of the Active Directory domain that this AD connector will be associated with.
 * @property serviceAccountProvisioning The service account provisioning mode for this Active Directory connector.
 */
public data class ActiveDirectoryConnectorDomainDetailsArgs(
    public val domainControllers: Output<ActiveDirectoryDomainControllersArgs>? = null,
    public val netbiosDomainName: Output<String>? = null,
    public val ouDistinguishedName: Output<String>? = null,
    public val realm: Output<String>,
    public val serviceAccountProvisioning: Output<Either<String, AccountProvisioningMode>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryConnectorDomainDetailsArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryConnectorDomainDetailsArgs =
        com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryConnectorDomainDetailsArgs.builder()
            .domainControllers(domainControllers?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .netbiosDomainName(netbiosDomainName?.applyValue({ args0 -> args0 }))
            .ouDistinguishedName(ouDistinguishedName?.applyValue({ args0 -> args0 }))
            .realm(realm.applyValue({ args0 -> args0 }))
            .serviceAccountProvisioning(
                serviceAccountProvisioning?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [ActiveDirectoryConnectorDomainDetailsArgs].
 */
@PulumiTagMarker
public class ActiveDirectoryConnectorDomainDetailsArgsBuilder internal constructor() {
    private var domainControllers: Output<ActiveDirectoryDomainControllersArgs>? = null

    private var netbiosDomainName: Output<String>? = null

    private var ouDistinguishedName: Output<String>? = null

    private var realm: Output<String>? = null

    private var serviceAccountProvisioning: Output<Either<String, AccountProvisioningMode>>? = null

    /**
     * @param value null
     */
    @JvmName("qrlowtqllxcrsrot")
    public suspend fun domainControllers(`value`: Output<ActiveDirectoryDomainControllersArgs>) {
        this.domainControllers = value
    }

    /**
     * @param value NETBIOS name of the Active Directory domain.
     */
    @JvmName("iiejxdahdywnudws")
    public suspend fun netbiosDomainName(`value`: Output<String>) {
        this.netbiosDomainName = value
    }

    /**
     * @param value The distinguished name of the Active Directory Organizational Unit.
     */
    @JvmName("fqngmdjbqcrtymcl")
    public suspend fun ouDistinguishedName(`value`: Output<String>) {
        this.ouDistinguishedName = value
    }

    /**
     * @param value Name (uppercase) of the Active Directory domain that this AD connector will be associated with.
     */
    @JvmName("nmbslocivlkxwmxu")
    public suspend fun realm(`value`: Output<String>) {
        this.realm = value
    }

    /**
     * @param value The service account provisioning mode for this Active Directory connector.
     */
    @JvmName("ppxasoccoutghqwa")
    public suspend
    fun serviceAccountProvisioning(`value`: Output<Either<String, AccountProvisioningMode>>) {
        this.serviceAccountProvisioning = value
    }

    /**
     * @param value null
     */
    @JvmName("sfduxlhepjhqynxb")
    public suspend fun domainControllers(`value`: ActiveDirectoryDomainControllersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainControllers = mapped
    }

    /**
     * @param argument null
     */
    @JvmName("qeukwwvkrptnwyxr")
    public suspend
    fun domainControllers(argument: suspend ActiveDirectoryDomainControllersArgsBuilder.() -> Unit) {
        val toBeMapped = ActiveDirectoryDomainControllersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.domainControllers = mapped
    }

    /**
     * @param value NETBIOS name of the Active Directory domain.
     */
    @JvmName("skrjidqvfklnqbxg")
    public suspend fun netbiosDomainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netbiosDomainName = mapped
    }

    /**
     * @param value The distinguished name of the Active Directory Organizational Unit.
     */
    @JvmName("gievtaonqlbtvmsq")
    public suspend fun ouDistinguishedName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ouDistinguishedName = mapped
    }

    /**
     * @param value Name (uppercase) of the Active Directory domain that this AD connector will be associated with.
     */
    @JvmName("kkmdrcuftxxpuckp")
    public suspend fun realm(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.realm = mapped
    }

    /**
     * @param value The service account provisioning mode for this Active Directory connector.
     */
    @JvmName("jcylshdyyjclrrbg")
    public suspend fun serviceAccountProvisioning(`value`: Either<String, AccountProvisioningMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceAccountProvisioning = mapped
    }

    /**
     * @param value The service account provisioning mode for this Active Directory connector.
     */
    @JvmName("ibtpdpijcpskefuy")
    public fun serviceAccountProvisioning(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AccountProvisioningMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceAccountProvisioning = mapped
    }

    /**
     * @param value The service account provisioning mode for this Active Directory connector.
     */
    @JvmName("pwqjxvpbmisrahly")
    public fun serviceAccountProvisioning(`value`: AccountProvisioningMode) {
        val toBeMapped = Either.ofRight<String, AccountProvisioningMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceAccountProvisioning = mapped
    }

    internal fun build(): ActiveDirectoryConnectorDomainDetailsArgs =
        ActiveDirectoryConnectorDomainDetailsArgs(
            domainControllers = domainControllers,
            netbiosDomainName = netbiosDomainName,
            ouDistinguishedName = ouDistinguishedName,
            realm = realm ?: throw PulumiNullFieldException("realm"),
            serviceAccountProvisioning = serviceAccountProvisioning,
        )
}
