@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.ExtendedLocationArgs.builder
import com.pulumi.azurenative.azurearcdata.kotlin.enums.ExtendedLocationTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The complex type of the extended location.
 * @property name The name of the extended location.
 * @property type The type of the extended location.
 */
public data class ExtendedLocationArgs(
    public val name: Output<String>? = null,
    public val type: Output<Either<String, ExtendedLocationTypes>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.ExtendedLocationArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.ExtendedLocationArgs =
        com.pulumi.azurenative.azurearcdata.inputs.ExtendedLocationArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ExtendedLocationArgs].
 */
@PulumiTagMarker
public class ExtendedLocationArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<Either<String, ExtendedLocationTypes>>? = null

    /**
     * @param value The name of the extended location.
     */
    @JvmName("iphmkgukkalxiclj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The type of the extended location.
     */
    @JvmName("amiacfnjjimfifvc")
    public suspend fun type(`value`: Output<Either<String, ExtendedLocationTypes>>) {
        this.type = value
    }

    /**
     * @param value The name of the extended location.
     */
    @JvmName("xxawvsyivrqqnylf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The type of the extended location.
     */
    @JvmName("bloanytnyvfwphod")
    public suspend fun type(`value`: Either<String, ExtendedLocationTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the extended location.
     */
    @JvmName("bonxdflnjfayslko")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ExtendedLocationTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the extended location.
     */
    @JvmName("fkjwfhfnghessbhn")
    public fun type(`value`: ExtendedLocationTypes) {
        val toBeMapped = Either.ofRight<String, ExtendedLocationTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ExtendedLocationArgs = ExtendedLocationArgs(
        name = name,
        type = type,
    )
}
