@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.KeytabInformationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Keytab used for authenticate with Active Directory.
 * @property keytab A base64-encoded keytab.
 */
public data class KeytabInformationArgs(
    public val keytab: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.KeytabInformationArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.KeytabInformationArgs =
        com.pulumi.azurenative.azurearcdata.inputs.KeytabInformationArgs.builder()
            .keytab(keytab?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeytabInformationArgs].
 */
@PulumiTagMarker
public class KeytabInformationArgsBuilder internal constructor() {
    private var keytab: Output<String>? = null

    /**
     * @param value A base64-encoded keytab.
     */
    @JvmName("frheqwvyupqvmqtq")
    public suspend fun keytab(`value`: Output<String>) {
        this.keytab = value
    }

    /**
     * @param value A base64-encoded keytab.
     */
    @JvmName("vhitomwmxbwqkmhv")
    public suspend fun keytab(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keytab = mapped
    }

    internal fun build(): KeytabInformationArgs = KeytabInformationArgs(
        keytab = keytab,
    )
}
