@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.OnPremisePropertyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties from the Kubernetes data controller
 * @property id A globally unique ID identifying the associated Kubernetes cluster
 * @property publicSigningKey Certificate that contains the Kubernetes cluster public key used to verify signing
 * @property signingCertificateThumbprint Unique thumbprint returned to customer to verify the certificate being uploaded
 */
public data class OnPremisePropertyArgs(
    public val id: Output<String>,
    public val publicSigningKey: Output<String>,
    public val signingCertificateThumbprint: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.OnPremisePropertyArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.OnPremisePropertyArgs =
        com.pulumi.azurenative.azurearcdata.inputs.OnPremisePropertyArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .publicSigningKey(publicSigningKey.applyValue({ args0 -> args0 }))
            .signingCertificateThumbprint(signingCertificateThumbprint?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OnPremisePropertyArgs].
 */
@PulumiTagMarker
public class OnPremisePropertyArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var publicSigningKey: Output<String>? = null

    private var signingCertificateThumbprint: Output<String>? = null

    /**
     * @param value A globally unique ID identifying the associated Kubernetes cluster
     */
    @JvmName("ufscebxlqkcktsca")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Certificate that contains the Kubernetes cluster public key used to verify signing
     */
    @JvmName("hrjlctuxrodwymwb")
    public suspend fun publicSigningKey(`value`: Output<String>) {
        this.publicSigningKey = value
    }

    /**
     * @param value Unique thumbprint returned to customer to verify the certificate being uploaded
     */
    @JvmName("wdgmyhefmlncmekw")
    public suspend fun signingCertificateThumbprint(`value`: Output<String>) {
        this.signingCertificateThumbprint = value
    }

    /**
     * @param value A globally unique ID identifying the associated Kubernetes cluster
     */
    @JvmName("ueaownitwsiilpal")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Certificate that contains the Kubernetes cluster public key used to verify signing
     */
    @JvmName("hcdfarvhdjrlodfw")
    public suspend fun publicSigningKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicSigningKey = mapped
    }

    /**
     * @param value Unique thumbprint returned to customer to verify the certificate being uploaded
     */
    @JvmName("rpffxjqbtbgrexkn")
    public suspend fun signingCertificateThumbprint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signingCertificateThumbprint = mapped
    }

    internal fun build(): OnPremisePropertyArgs = OnPremisePropertyArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        publicSigningKey = publicSigningKey ?: throw PulumiNullFieldException("publicSigningKey"),
        signingCertificateThumbprint = signingCertificateThumbprint,
    )
}
