@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.SqlServerDatabaseResourcePropertiesBackupInformationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property lastFullBackup Date time of last full backup.
 * @property lastLogBackup Date time of last log backup.
 */
public data class SqlServerDatabaseResourcePropertiesBackupInformationArgs(
    public val lastFullBackup: Output<String>? = null,
    public val lastLogBackup: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.SqlServerDatabaseResourcePropertiesBackupInformationArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurearcdata.inputs.SqlServerDatabaseResourcePropertiesBackupInformationArgs =
        com.pulumi.azurenative.azurearcdata.inputs.SqlServerDatabaseResourcePropertiesBackupInformationArgs.builder()
            .lastFullBackup(lastFullBackup?.applyValue({ args0 -> args0 }))
            .lastLogBackup(lastLogBackup?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlServerDatabaseResourcePropertiesBackupInformationArgs].
 */
@PulumiTagMarker
public class SqlServerDatabaseResourcePropertiesBackupInformationArgsBuilder internal constructor() {
    private var lastFullBackup: Output<String>? = null

    private var lastLogBackup: Output<String>? = null

    /**
     * @param value Date time of last full backup.
     */
    @JvmName("kejadjgortoxwuwi")
    public suspend fun lastFullBackup(`value`: Output<String>) {
        this.lastFullBackup = value
    }

    /**
     * @param value Date time of last log backup.
     */
    @JvmName("yfwqcgnftleemcef")
    public suspend fun lastLogBackup(`value`: Output<String>) {
        this.lastLogBackup = value
    }

    /**
     * @param value Date time of last full backup.
     */
    @JvmName("hyuuubkgrpvadoyp")
    public suspend fun lastFullBackup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastFullBackup = mapped
    }

    /**
     * @param value Date time of last log backup.
     */
    @JvmName("rhtwaawwrqrrflet")
    public suspend fun lastLogBackup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastLogBackup = mapped
    }

    internal fun build(): SqlServerDatabaseResourcePropertiesBackupInformationArgs =
        SqlServerDatabaseResourcePropertiesBackupInformationArgs(
            lastFullBackup = lastFullBackup,
            lastLogBackup = lastLogBackup,
        )
}
