@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.UploadServicePrincipalArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Service principal for uploading billing, metrics and logs.
 * @property authority Authority for the service principal. Example: https://login.microsoftonline.com/
 * @property clientId Client ID of the service principal for uploading data.
 * @property clientSecret Secret of the service principal
 * @property tenantId Tenant ID of the service principal.
 */
public data class UploadServicePrincipalArgs(
    public val authority: Output<String>? = null,
    public val clientId: Output<String>? = null,
    public val clientSecret: Output<String>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.UploadServicePrincipalArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.UploadServicePrincipalArgs =
        com.pulumi.azurenative.azurearcdata.inputs.UploadServicePrincipalArgs.builder()
            .authority(authority?.applyValue({ args0 -> args0 }))
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UploadServicePrincipalArgs].
 */
@PulumiTagMarker
public class UploadServicePrincipalArgsBuilder internal constructor() {
    private var authority: Output<String>? = null

    private var clientId: Output<String>? = null

    private var clientSecret: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value Authority for the service principal. Example: https://login.microsoftonline.com/
     */
    @JvmName("krijjhgnnyelcpah")
    public suspend fun authority(`value`: Output<String>) {
        this.authority = value
    }

    /**
     * @param value Client ID of the service principal for uploading data.
     */
    @JvmName("mmtdtipmjcwdasvh")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value Secret of the service principal
     */
    @JvmName("jdixbnafyauqdypu")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value Tenant ID of the service principal.
     */
    @JvmName("ttnsbrksaawtelvg")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Authority for the service principal. Example: https://login.microsoftonline.com/
     */
    @JvmName("rtvhowpcmrsebuhi")
    public suspend fun authority(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authority = mapped
    }

    /**
     * @param value Client ID of the service principal for uploading data.
     */
    @JvmName("engjbxuxsxhnkgcf")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value Secret of the service principal
     */
    @JvmName("vkxiigmbryxymogl")
    public suspend fun clientSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value Tenant ID of the service principal.
     */
    @JvmName("ccowwfojsietskhy")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): UploadServicePrincipalArgs = UploadServicePrincipalArgs(
        authority = authority,
        clientId = clientId,
        clientSecret = clientSecret,
        tenantId = tenantId,
    )
}
