@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.UploadWatermarkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties on upload watermark.  Mostly timestamp for each upload data type
 * @property logs Last uploaded date for logs from kubernetes cluster. Defaults to current date time
 * @property metrics Last uploaded date for metrics from kubernetes cluster. Defaults to current date time
 * @property usages Last uploaded date for usages from kubernetes cluster. Defaults to current date time
 */
public data class UploadWatermarkArgs(
    public val logs: Output<String>? = null,
    public val metrics: Output<String>? = null,
    public val usages: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.UploadWatermarkArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.UploadWatermarkArgs =
        com.pulumi.azurenative.azurearcdata.inputs.UploadWatermarkArgs.builder()
            .logs(logs?.applyValue({ args0 -> args0 }))
            .metrics(metrics?.applyValue({ args0 -> args0 }))
            .usages(usages?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UploadWatermarkArgs].
 */
@PulumiTagMarker
public class UploadWatermarkArgsBuilder internal constructor() {
    private var logs: Output<String>? = null

    private var metrics: Output<String>? = null

    private var usages: Output<String>? = null

    /**
     * @param value Last uploaded date for logs from kubernetes cluster. Defaults to current date time
     */
    @JvmName("ugnqglstnsnvximf")
    public suspend fun logs(`value`: Output<String>) {
        this.logs = value
    }

    /**
     * @param value Last uploaded date for metrics from kubernetes cluster. Defaults to current date time
     */
    @JvmName("pwfenuwyrshvlqxe")
    public suspend fun metrics(`value`: Output<String>) {
        this.metrics = value
    }

    /**
     * @param value Last uploaded date for usages from kubernetes cluster. Defaults to current date time
     */
    @JvmName("cbovddfarukbldcy")
    public suspend fun usages(`value`: Output<String>) {
        this.usages = value
    }

    /**
     * @param value Last uploaded date for logs from kubernetes cluster. Defaults to current date time
     */
    @JvmName("emdrkfqhatrgvnrm")
    public suspend fun logs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logs = mapped
    }

    /**
     * @param value Last uploaded date for metrics from kubernetes cluster. Defaults to current date time
     */
    @JvmName("okcxqeronungxnig")
    public suspend fun metrics(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metrics = mapped
    }

    /**
     * @param value Last uploaded date for usages from kubernetes cluster. Defaults to current date time
     */
    @JvmName("eyjlyrypvplfypen")
    public suspend fun usages(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usages = mapped
    }

    internal fun build(): UploadWatermarkArgs = UploadWatermarkArgs(
        logs = logs,
        metrics = metrics,
        usages = usages,
    )
}
