@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The kubernetes security information.
 * @property activeDirectory The kubernetes active directory information.
 * @property adminLoginSecret Admin login secret key
 * @property serviceCertificateSecret Service certificate secret used
 * @property transparentDataEncryption Transparent data encryption information.
 */
public data class K8sSecurityResponse(
    public val activeDirectory: K8sActiveDirectoryResponse? = null,
    public val adminLoginSecret: String? = null,
    public val serviceCertificateSecret: String? = null,
    public val transparentDataEncryption: K8stransparentDataEncryptionResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.K8sSecurityResponse):
            K8sSecurityResponse = K8sSecurityResponse(
            activeDirectory = javaType.activeDirectory().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurearcdata.kotlin.outputs.K8sActiveDirectoryResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            adminLoginSecret = javaType.adminLoginSecret().map({ args0 -> args0 }).orElse(null),
            serviceCertificateSecret = javaType.serviceCertificateSecret().map({ args0 -> args0 }).orElse(null),
            transparentDataEncryption = javaType.transparentDataEncryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurearcdata.kotlin.outputs.K8stransparentDataEncryptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
