@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The resource model definition representing SKU for Azure Managed Instance - Azure Arc
 * @property capacity The SKU capacity
 * @property dev Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose.
 * @property family The SKU family
 * @property name The name of the SKU.
 * @property size The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
 * @property tier The pricing tier for the instance.
 */
public data class SqlManagedInstanceSkuResponse(
    public val capacity: Int? = null,
    public val dev: Boolean? = null,
    public val family: String? = null,
    public val name: String,
    public val size: String? = null,
    public val tier: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.SqlManagedInstanceSkuResponse):
            SqlManagedInstanceSkuResponse = SqlManagedInstanceSkuResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            dev = javaType.dev().map({ args0 -> args0 }).orElse(null),
            family = javaType.family().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            size = javaType.size().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
