@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredata.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SqlServer].
 */
@PulumiTagMarker
public class SqlServerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SqlServerArgs = SqlServerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SqlServerArgsBuilder.() -> Unit) {
        val builder = SqlServerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SqlServer {
        val builtJavaResource = com.pulumi.azurenative.azuredata.SqlServer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SqlServer(builtJavaResource)
    }
}

/**
 * A SQL server.
 * Azure REST API version: 2019-07-24-preview. Prior API version in Azure Native 1.x: 2019-07-24-preview.
 * ## Example Usage
 * ### Creates or updates a SQL Server in a Registration group.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlServer = new AzureNative.AzureData.SqlServer("sqlServer", new()
 *     {
 *         Cores = 8,
 *         Edition = "Latin",
 *         PropertyBag = "",
 *         RegistrationID = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.AzureData/SqlServerRegistrations/testsqlregistration",
 *         ResourceGroupName = "testrg",
 *         SqlServerName = "testsqlserver",
 *         SqlServerRegistrationName = "testsqlregistration",
 *         Version = "2008",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azuredata/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azuredata.NewSqlServer(ctx, "sqlServer", &azuredata.SqlServerArgs{
 * 			Cores:                     pulumi.Int(8),
 * 			Edition:                   pulumi.String("Latin"),
 * 			PropertyBag:               pulumi.String(""),
 * 			RegistrationID:            pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.AzureData/SqlServerRegistrations/testsqlregistration"),
 * 			ResourceGroupName:         pulumi.String("testrg"),
 * 			SqlServerName:             pulumi.String("testsqlserver"),
 * 			SqlServerRegistrationName: pulumi.String("testsqlregistration"),
 * 			Version:                   pulumi.String("2008"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azuredata.SqlServer;
 * import com.pulumi.azurenative.azuredata.SqlServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlServer = new SqlServer("sqlServer", SqlServerArgs.builder()
 *             .cores(8)
 *             .edition("Latin")
 *             .propertyBag("")
 *             .registrationID("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.AzureData/SqlServerRegistrations/testsqlregistration")
 *             .resourceGroupName("testrg")
 *             .sqlServerName("testsqlserver")
 *             .sqlServerRegistrationName("testsqlregistration")
 *             .version("2008")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azuredata:SqlServer testsqlserver /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureData/sqlServerRegistrations/{sqlServerRegistrationName}/sqlServers/{sqlServerName}
 * ```
 */
public class SqlServer internal constructor(
    override val javaResource: com.pulumi.azurenative.azuredata.SqlServer,
) : KotlinCustomResource(javaResource, SqlServerMapper) {
    /**
     * Cores of the Sql Server.
     */
    public val cores: Output<Int>?
        get() = javaResource.cores().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Sql Server Edition.
     */
    public val edition: Output<String>?
        get() = javaResource.edition().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Sql Server Json Property Bag.
     */
    public val propertyBag: Output<String>?
        get() = javaResource.propertyBag().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ID for Parent Sql Server Registration.
     */
    public val registrationID: Output<String>?
        get() = javaResource.registrationID().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Version of the Sql Server.
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object SqlServerMapper : ResourceMapper<SqlServer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azuredata.SqlServer::class == javaResource::class

    override fun map(javaResource: Resource): SqlServer = SqlServer(
        javaResource as
            com.pulumi.azurenative.azuredata.SqlServer,
    )
}

/**
 * @see [SqlServer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SqlServer].
 */
public suspend fun sqlServer(name: String, block: suspend SqlServerResourceBuilder.() -> Unit):
    SqlServer {
    val builder = SqlServerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SqlServer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sqlServer(name: String): SqlServer {
    val builder = SqlServerResourceBuilder()
    builder.name(name)
    return builder.build()
}
