@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredata.kotlin

import com.pulumi.azurenative.azuredata.SqlServerRegistrationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A SQL server registration.
 * Azure REST API version: 2019-07-24-preview. Prior API version in Azure Native 1.x: 2019-07-24-preview.
 * ## Example Usage
 * ### Creates or updates a SQL Server registration.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlServerRegistration = new AzureNative.AzureData.SqlServerRegistration("sqlServerRegistration", new()
 *     {
 *         Location = "northeurope",
 *         ResourceGroupName = "testrg",
 *         SqlServerRegistrationName = "testsqlregistration",
 *         Tags =
 *         {
 *             { "mytag", "myval" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azuredata/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azuredata.NewSqlServerRegistration(ctx, "sqlServerRegistration", &azuredata.SqlServerRegistrationArgs{
 * 			Location:                  pulumi.String("northeurope"),
 * 			ResourceGroupName:         pulumi.String("testrg"),
 * 			SqlServerRegistrationName: pulumi.String("testsqlregistration"),
 * 			Tags: pulumi.StringMap{
 * 				"mytag": pulumi.String("myval"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azuredata.SqlServerRegistration;
 * import com.pulumi.azurenative.azuredata.SqlServerRegistrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlServerRegistration = new SqlServerRegistration("sqlServerRegistration", SqlServerRegistrationArgs.builder()
 *             .location("northeurope")
 *             .resourceGroupName("testrg")
 *             .sqlServerRegistrationName("testsqlregistration")
 *             .tags(Map.of("mytag", "myval"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azuredata:SqlServerRegistration testsqlregistration /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureData/sqlServerRegistrations/{sqlServerRegistrationName}
 * ```
 * @property location The geo-location where the resource lives
 * @property propertyBag Optional Properties as JSON string
 * @property resourceGroup Resource Group Name
 * @property resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property sqlServerRegistrationName Name of the SQL Server registration.
 * @property subscriptionId Subscription Id
 * @property tags Resource tags.
 */
public data class SqlServerRegistrationArgs(
    public val location: Output<String>? = null,
    public val propertyBag: Output<String>? = null,
    public val resourceGroup: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sqlServerRegistrationName: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azuredata.SqlServerRegistrationArgs> {
    override fun toJava(): com.pulumi.azurenative.azuredata.SqlServerRegistrationArgs =
        com.pulumi.azurenative.azuredata.SqlServerRegistrationArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .propertyBag(propertyBag?.applyValue({ args0 -> args0 }))
            .resourceGroup(resourceGroup?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sqlServerRegistrationName(sqlServerRegistrationName?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SqlServerRegistrationArgs].
 */
@PulumiTagMarker
public class SqlServerRegistrationArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var propertyBag: Output<String>? = null

    private var resourceGroup: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sqlServerRegistrationName: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rbxqrvviwjkpgbfo")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Optional Properties as JSON string
     */
    @JvmName("wpssolvwqdjmfbwh")
    public suspend fun propertyBag(`value`: Output<String>) {
        this.propertyBag = value
    }

    /**
     * @param value Resource Group Name
     */
    @JvmName("hpfssojstvvjxtoj")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("fikqsqyrtnjuxgut")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the SQL Server registration.
     */
    @JvmName("jhbjxbprgefobxgh")
    public suspend fun sqlServerRegistrationName(`value`: Output<String>) {
        this.sqlServerRegistrationName = value
    }

    /**
     * @param value Subscription Id
     */
    @JvmName("txtenmwwaalorlkf")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tbwdvswloqpccuyv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("fynhgkihiabuenmk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Optional Properties as JSON string
     */
    @JvmName("ftbomvkcqbvygmjq")
    public suspend fun propertyBag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propertyBag = mapped
    }

    /**
     * @param value Resource Group Name
     */
    @JvmName("olmmtoqoqwwuqglj")
    public suspend fun resourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    /**
     * @param value Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("rhedmjoukpsngiot")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the SQL Server registration.
     */
    @JvmName("qogybmogachbdkkj")
    public suspend fun sqlServerRegistrationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlServerRegistrationName = mapped
    }

    /**
     * @param value Subscription Id
     */
    @JvmName("nudjnngscbgtmhni")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ttfhdsscpmehaptp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("dvvxuthfwvwyqclk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SqlServerRegistrationArgs = SqlServerRegistrationArgs(
        location = location,
        propertyBag = propertyBag,
        resourceGroup = resourceGroup,
        resourceGroupName = resourceGroupName,
        sqlServerRegistrationName = sqlServerRegistrationName,
        subscriptionId = subscriptionId,
        tags = tags,
    )
}
