@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin

import com.pulumi.azurenative.azuredatatransfer.ConnectionArgs.builder
import com.pulumi.azurenative.azuredatatransfer.kotlin.inputs.ConnectionPropertiesArgs
import com.pulumi.azurenative.azuredatatransfer.kotlin.inputs.ConnectionPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The connection resource definition.
 * Azure REST API version: 2023-10-11-preview.
 * ## Example Usage
 * ### Creates or updates the connection resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connection = new AzureNative.AzureDataTransfer.Connection("connection", new()
 *     {
 *         ConnectionName = "testConnection",
 *         Location = "East US",
 *         Properties = new AzureNative.AzureDataTransfer.Inputs.ConnectionPropertiesArgs
 *         {
 *             Justification = "justification",
 *             Pipeline = "testdc",
 *             RequirementId = "id",
 *         },
 *         ResourceGroupName = "testRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azuredatatransfer/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azuredatatransfer.NewConnection(ctx, "connection", &azuredatatransfer.ConnectionArgs{
 * 			ConnectionName: pulumi.String("testConnection"),
 * 			Location:       pulumi.String("East US"),
 * 			Properties: &azuredatatransfer.ConnectionPropertiesArgs{
 * 				Justification: pulumi.String("justification"),
 * 				Pipeline:      pulumi.String("testdc"),
 * 				RequirementId: pulumi.String("id"),
 * 			},
 * 			ResourceGroupName: pulumi.String("testRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azuredatatransfer.Connection;
 * import com.pulumi.azurenative.azuredatatransfer.ConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connection = new Connection("connection", ConnectionArgs.builder()
 *             .connectionName("testConnection")
 *             .location("East US")
 *             .properties(Map.ofEntries(
 *                 Map.entry("justification", "justification"),
 *                 Map.entry("pipeline", "testdc"),
 *                 Map.entry("requirementId", "id")
 *             ))
 *             .resourceGroupName("testRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azuredatatransfer:Connection myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureDataTransfer/connections/{connectionName}
 * ```
 * @property connectionName The name for the connection that is to be requested.
 * @property location The geo-location where the resource lives
 * @property properties Properties of connection
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class ConnectionArgs(
    public val connectionName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<ConnectionPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azuredatatransfer.ConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.azuredatatransfer.ConnectionArgs =
        com.pulumi.azurenative.azuredatatransfer.ConnectionArgs.builder()
            .connectionName(connectionName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ConnectionArgs].
 */
@PulumiTagMarker
public class ConnectionArgsBuilder internal constructor() {
    private var connectionName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<ConnectionPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name for the connection that is to be requested.
     */
    @JvmName("oqljcaeaoscefady")
    public suspend fun connectionName(`value`: Output<String>) {
        this.connectionName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rlouagpdneqeefvd")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Properties of connection
     */
    @JvmName("kcphletwpayxycyn")
    public suspend fun properties(`value`: Output<ConnectionPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ljytmsdqikwpqnop")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("cuoelkeygnefiscw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name for the connection that is to be requested.
     */
    @JvmName("btdlisyoiiiuesbj")
    public suspend fun connectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("uvcbcpdrwhscmebm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Properties of connection
     */
    @JvmName("qlsacwsutyftbhgs")
    public suspend fun properties(`value`: ConnectionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of connection
     */
    @JvmName("cgdsqhjnxygvmcge")
    public suspend fun properties(argument: suspend ConnectionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("niucfronutjpexmv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ehlukrdpcmiodtji")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("pfobdnyjlchdmgqo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ConnectionArgs = ConnectionArgs(
        connectionName = connectionName,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
