@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin

import com.pulumi.azurenative.azuredatatransfer.FlowArgs.builder
import com.pulumi.azurenative.azuredatatransfer.kotlin.inputs.FlowPropertiesArgs
import com.pulumi.azurenative.azuredatatransfer.kotlin.inputs.FlowPropertiesArgsBuilder
import com.pulumi.azurenative.azuredatatransfer.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.azuredatatransfer.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.azuredatatransfer.kotlin.inputs.PlanArgs
import com.pulumi.azurenative.azuredatatransfer.kotlin.inputs.PlanArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The flow resource definition.
 * Azure REST API version: 2023-10-11-preview.
 * ## Example Usage
 * ### Creates or updates the flow resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var flow = new AzureNative.AzureDataTransfer.Flow("flow", new()
 *     {
 *         ConnectionName = "testConnection",
 *         FlowName = "testFlow",
 *         Location = "East US",
 *         Properties = new AzureNative.AzureDataTransfer.Inputs.FlowPropertiesArgs
 *         {
 *             Connection = new AzureNative.AzureDataTransfer.Inputs.SelectedResourceArgs
 *             {
 *                 Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testRG/providers/Microsoft.AzureDataTransfer/connections/testConnection",
 *             },
 *             FlowType = "Blob",
 *             StorageAccountName = "testsa",
 *             StorageContainerName = "testcontainer",
 *         },
 *         ResourceGroupName = "testRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azuredatatransfer/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azuredatatransfer.NewFlow(ctx, "flow", &azuredatatransfer.FlowArgs{
 * 			ConnectionName: pulumi.String("testConnection"),
 * 			FlowName:       pulumi.String("testFlow"),
 * 			Location:       pulumi.String("East US"),
 * 			Properties: azuredatatransfer.FlowPropertiesResponse{
 * 				Connection: &azuredatatransfer.SelectedResourceArgs{
 * 					Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testRG/providers/Microsoft.AzureDataTransfer/connections/testConnection"),
 * 				},
 * 				FlowType:             pulumi.String("Blob"),
 * 				StorageAccountName:   pulumi.String("testsa"),
 * 				StorageContainerName: pulumi.String("testcontainer"),
 * 			},
 * 			ResourceGroupName: pulumi.String("testRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azuredatatransfer.Flow;
 * import com.pulumi.azurenative.azuredatatransfer.FlowArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var flow = new Flow("flow", FlowArgs.builder()
 *             .connectionName("testConnection")
 *             .flowName("testFlow")
 *             .location("East US")
 *             .properties(Map.ofEntries(
 *                 Map.entry("connection", Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testRG/providers/Microsoft.AzureDataTransfer/connections/testConnection")),
 *                 Map.entry("flowType", "Blob"),
 *                 Map.entry("storageAccountName", "testsa"),
 *                 Map.entry("storageContainerName", "testcontainer")
 *             ))
 *             .resourceGroupName("testRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azuredatatransfer:Flow myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureDataTransfer/connections/{connectionName}/flows/{flowName}
 * ```
 * @property connectionName The name for the connection that is to be requested.
 * @property flowName The name for the flow that is to be onboarded.
 * @property identity The managed identity of the flow resource, if configured.
 * @property location The geo-location where the resource lives
 * @property plan Plan for the resource.
 * @property properties Properties of flow
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class FlowArgs(
    public val connectionName: Output<String>? = null,
    public val flowName: Output<String>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val plan: Output<PlanArgs>? = null,
    public val properties: Output<FlowPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azuredatatransfer.FlowArgs> {
    override fun toJava(): com.pulumi.azurenative.azuredatatransfer.FlowArgs =
        com.pulumi.azurenative.azuredatatransfer.FlowArgs.builder()
            .connectionName(connectionName?.applyValue({ args0 -> args0 }))
            .flowName(flowName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .plan(plan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FlowArgs].
 */
@PulumiTagMarker
public class FlowArgsBuilder internal constructor() {
    private var connectionName: Output<String>? = null

    private var flowName: Output<String>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var plan: Output<PlanArgs>? = null

    private var properties: Output<FlowPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name for the connection that is to be requested.
     */
    @JvmName("swflypgoiyjlyyxi")
    public suspend fun connectionName(`value`: Output<String>) {
        this.connectionName = value
    }

    /**
     * @param value The name for the flow that is to be onboarded.
     */
    @JvmName("dvnmjnmfuiblmfrf")
    public suspend fun flowName(`value`: Output<String>) {
        this.flowName = value
    }

    /**
     * @param value The managed identity of the flow resource, if configured.
     */
    @JvmName("bmrldbhxdgjrtuop")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("eyaijvvvpluydebg")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Plan for the resource.
     */
    @JvmName("wfcocdbkhbfinupv")
    public suspend fun plan(`value`: Output<PlanArgs>) {
        this.plan = value
    }

    /**
     * @param value Properties of flow
     */
    @JvmName("bgwwfghiblixlpnv")
    public suspend fun properties(`value`: Output<FlowPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("talepadtebmeoaum")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("twuokycvsnfoxpub")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name for the connection that is to be requested.
     */
    @JvmName("nkevtqxarwdkrmoj")
    public suspend fun connectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionName = mapped
    }

    /**
     * @param value The name for the flow that is to be onboarded.
     */
    @JvmName("wecqkxprdgtspoms")
    public suspend fun flowName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flowName = mapped
    }

    /**
     * @param value The managed identity of the flow resource, if configured.
     */
    @JvmName("eqohskuxbwmdxxnh")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The managed identity of the flow resource, if configured.
     */
    @JvmName("oyigcscokhiwclic")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("umtdxlqbsfskffuy")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Plan for the resource.
     */
    @JvmName("jiuccbiplbfukrii")
    public suspend fun plan(`value`: PlanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plan = mapped
    }

    /**
     * @param argument Plan for the resource.
     */
    @JvmName("vcwdjjocjwxvmamw")
    public suspend fun plan(argument: suspend PlanArgsBuilder.() -> Unit) {
        val toBeMapped = PlanArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.plan = mapped
    }

    /**
     * @param value Properties of flow
     */
    @JvmName("nckqmsacybwlsbsd")
    public suspend fun properties(`value`: FlowPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of flow
     */
    @JvmName("stgirxswjdonptns")
    public suspend fun properties(argument: suspend FlowPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = FlowPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jexlpmomgjnoehpx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qfiupfgatpxomtiu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("pqyvqkrgdwltxdfi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FlowArgs = FlowArgs(
        connectionName = connectionName,
        flowName = flowName,
        identity = identity,
        location = location,
        plan = plan,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
