@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin.inputs

import com.pulumi.azurenative.azuredatatransfer.inputs.GetPipelinePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property pipelineName The name for the pipeline that is to be requested.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetPipelinePlainArgs(
    public val pipelineName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azuredatatransfer.inputs.GetPipelinePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azuredatatransfer.inputs.GetPipelinePlainArgs =
        com.pulumi.azurenative.azuredatatransfer.inputs.GetPipelinePlainArgs.builder()
            .pipelineName(pipelineName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPipelinePlainArgs].
 */
@PulumiTagMarker
public class GetPipelinePlainArgsBuilder internal constructor() {
    private var pipelineName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name for the pipeline that is to be requested.
     */
    @JvmName("gvkhmgyekildgvbw")
    public suspend fun pipelineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.pipelineName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gvqstlevvfbwojno")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPipelinePlainArgs = GetPipelinePlainArgs(
        pipelineName = pipelineName ?: throw PulumiNullFieldException("pipelineName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
