@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin.inputs

import com.pulumi.azurenative.azuredatatransfer.inputs.SchemaArgs.builder
import com.pulumi.azurenative.azuredatatransfer.kotlin.enums.SchemaStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The schema object.
 * @property connectionId Connection ID associated with this schema
 * @property content Content of the schema
 * @property id ID associated with this schema
 * @property name Name of the schema
 * @property status Status of the schema
 */
public data class SchemaArgs(
    public val connectionId: Output<String>? = null,
    public val content: Output<String>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val status: Output<Either<String, SchemaStatus>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azuredatatransfer.inputs.SchemaArgs> {
    override fun toJava(): com.pulumi.azurenative.azuredatatransfer.inputs.SchemaArgs =
        com.pulumi.azurenative.azuredatatransfer.inputs.SchemaArgs.builder()
            .connectionId(connectionId?.applyValue({ args0 -> args0 }))
            .content(content?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SchemaArgs].
 */
@PulumiTagMarker
public class SchemaArgsBuilder internal constructor() {
    private var connectionId: Output<String>? = null

    private var content: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var status: Output<Either<String, SchemaStatus>>? = null

    /**
     * @param value Connection ID associated with this schema
     */
    @JvmName("ebawgfruxlymalqd")
    public suspend fun connectionId(`value`: Output<String>) {
        this.connectionId = value
    }

    /**
     * @param value Content of the schema
     */
    @JvmName("nkjnbspljdmjshbq")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value ID associated with this schema
     */
    @JvmName("mnghwiedkfgpwfjf")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the schema
     */
    @JvmName("uxppwdubwxadsdqq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Status of the schema
     */
    @JvmName("ryabehxhoackbewq")
    public suspend fun status(`value`: Output<Either<String, SchemaStatus>>) {
        this.status = value
    }

    /**
     * @param value Connection ID associated with this schema
     */
    @JvmName("ausheilliapfkbvs")
    public suspend fun connectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionId = mapped
    }

    /**
     * @param value Content of the schema
     */
    @JvmName("rtyxvtjykogbgsxu")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value ID associated with this schema
     */
    @JvmName("hpqawrfhsslpxuvq")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the schema
     */
    @JvmName("kyqlbhawueflujqp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Status of the schema
     */
    @JvmName("nokyfvdoiinxuiit")
    public suspend fun status(`value`: Either<String, SchemaStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Status of the schema
     */
    @JvmName("lbvdgvfqtdijgxkc")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SchemaStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Status of the schema
     */
    @JvmName("inoprbamurerpgvs")
    public fun status(`value`: SchemaStatus) {
        val toBeMapped = Either.ofRight<String, SchemaStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): SchemaArgs = SchemaArgs(
        connectionId = connectionId,
        content = content,
        id = id,
        name = name,
        status = status,
    )
}
