@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Operation status associated with the last patch request
 * @property id Operation status ID of the last patch request for this connection.
 * @property message Message for the operation for the last patch request for this connection.
 * @property status Operation status for the last patch request for this connection.
 */
public data class OperationStatusPropertiesResponse(
    public val id: String,
    public val message: String,
    public val status: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azuredatatransfer.outputs.OperationStatusPropertiesResponse):
            OperationStatusPropertiesResponse = OperationStatusPropertiesResponse(
            id = javaType.id(),
            message = javaType.message(),
            status = javaType.status(),
        )
    }
}
