@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azureplaywrightservice.kotlin

import com.pulumi.azurenative.azureplaywrightservice.AccountArgs.builder
import com.pulumi.azurenative.azureplaywrightservice.kotlin.enums.EnablementStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An account resource
 * Azure REST API version: 2023-10-01-preview.
 * Other available API versions: 2024-02-01-preview.
 * ## Example Usage
 * ### Accounts_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new AzureNative.AzurePlaywrightService.Account("account", new()
 *     {
 *         Location = "westus",
 *         Name = "myPlaywrightAccount",
 *         RegionalAffinity = "Enabled",
 *         ResourceGroupName = "dummyrg",
 *         Tags =
 *         {
 *             { "Team", "Dev Exp" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azureplaywrightservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azureplaywrightservice.NewAccount(ctx, "account", &azureplaywrightservice.AccountArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Name:              pulumi.String("myPlaywrightAccount"),
 * 			RegionalAffinity:  pulumi.String("Enabled"),
 * 			ResourceGroupName: pulumi.String("dummyrg"),
 * 			Tags: pulumi.StringMap{
 * 				"Team": pulumi.String("Dev Exp"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azureplaywrightservice.Account;
 * import com.pulumi.azurenative.azureplaywrightservice.AccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .location("westus")
 *             .name("myPlaywrightAccount")
 *             .regionalAffinity("Enabled")
 *             .resourceGroupName("dummyrg")
 *             .tags(Map.of("Team", "Dev Exp"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azureplaywrightservice:Account myPlaywrightAccount /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzurePlaywrightService/accounts/{name}
 * ```
 * @property location The geo-location where the resource lives
 * @property name Name of account
 * @property regionalAffinity This property sets the connection region for Playwright client workers to cloud-hosted browsers. If enabled, workers connect to browsers in the closest Azure region, ensuring lower latency. If disabled, workers connect to browsers in the Azure region in which the workspace was initially created.
 * @property reporting When enabled, this feature allows the workspace to upload and display test results, including artifacts like traces and screenshots, in the Playwright portal. This enables faster and more efficient troubleshooting.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scalableExecution When enabled, Playwright client workers can connect to cloud-hosted browsers. This can increase the number of parallel workers for a test run, significantly minimizing test completion durations.
 * @property tags Resource tags.
 */
public data class AccountArgs(
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val regionalAffinity: Output<Either<String, EnablementStatus>>? = null,
    public val reporting: Output<Either<String, EnablementStatus>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scalableExecution: Output<Either<String, EnablementStatus>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azureplaywrightservice.AccountArgs> {
    override fun toJava(): com.pulumi.azurenative.azureplaywrightservice.AccountArgs =
        com.pulumi.azurenative.azureplaywrightservice.AccountArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .regionalAffinity(
                regionalAffinity?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .reporting(
                reporting?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scalableExecution(
                scalableExecution?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AccountArgs].
 */
@PulumiTagMarker
public class AccountArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var regionalAffinity: Output<Either<String, EnablementStatus>>? = null

    private var reporting: Output<Either<String, EnablementStatus>>? = null

    private var resourceGroupName: Output<String>? = null

    private var scalableExecution: Output<Either<String, EnablementStatus>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("gylrpfbycsgqijjq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of account
     */
    @JvmName("rjlmwwcyeysxgyrx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value This property sets the connection region for Playwright client workers to cloud-hosted browsers. If enabled, workers connect to browsers in the closest Azure region, ensuring lower latency. If disabled, workers connect to browsers in the Azure region in which the workspace was initially created.
     */
    @JvmName("thuqbbpowuipbuou")
    public suspend fun regionalAffinity(`value`: Output<Either<String, EnablementStatus>>) {
        this.regionalAffinity = value
    }

    /**
     * @param value When enabled, this feature allows the workspace to upload and display test results, including artifacts like traces and screenshots, in the Playwright portal. This enables faster and more efficient troubleshooting.
     */
    @JvmName("biltjusqyghckkky")
    public suspend fun reporting(`value`: Output<Either<String, EnablementStatus>>) {
        this.reporting = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yeunpatprpiqscuu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value When enabled, Playwright client workers can connect to cloud-hosted browsers. This can increase the number of parallel workers for a test run, significantly minimizing test completion durations.
     */
    @JvmName("pqchscjugutgyqle")
    public suspend fun scalableExecution(`value`: Output<Either<String, EnablementStatus>>) {
        this.scalableExecution = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rdijltnlaacwkdev")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("semvcteikhhcjaty")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of account
     */
    @JvmName("cmqmxxoankqchxdb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value This property sets the connection region for Playwright client workers to cloud-hosted browsers. If enabled, workers connect to browsers in the closest Azure region, ensuring lower latency. If disabled, workers connect to browsers in the Azure region in which the workspace was initially created.
     */
    @JvmName("odvmubywdtkytebp")
    public suspend fun regionalAffinity(`value`: Either<String, EnablementStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionalAffinity = mapped
    }

    /**
     * @param value This property sets the connection region for Playwright client workers to cloud-hosted browsers. If enabled, workers connect to browsers in the closest Azure region, ensuring lower latency. If disabled, workers connect to browsers in the Azure region in which the workspace was initially created.
     */
    @JvmName("uepnrlqqlbustnlj")
    public fun regionalAffinity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnablementStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regionalAffinity = mapped
    }

    /**
     * @param value This property sets the connection region for Playwright client workers to cloud-hosted browsers. If enabled, workers connect to browsers in the closest Azure region, ensuring lower latency. If disabled, workers connect to browsers in the Azure region in which the workspace was initially created.
     */
    @JvmName("jncpaetobixlluqi")
    public fun regionalAffinity(`value`: EnablementStatus) {
        val toBeMapped = Either.ofRight<String, EnablementStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regionalAffinity = mapped
    }

    /**
     * @param value When enabled, this feature allows the workspace to upload and display test results, including artifacts like traces and screenshots, in the Playwright portal. This enables faster and more efficient troubleshooting.
     */
    @JvmName("tbksmqbkvpgjmwut")
    public suspend fun reporting(`value`: Either<String, EnablementStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reporting = mapped
    }

    /**
     * @param value When enabled, this feature allows the workspace to upload and display test results, including artifacts like traces and screenshots, in the Playwright portal. This enables faster and more efficient troubleshooting.
     */
    @JvmName("vaukqabxfkpesste")
    public fun reporting(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnablementStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reporting = mapped
    }

    /**
     * @param value When enabled, this feature allows the workspace to upload and display test results, including artifacts like traces and screenshots, in the Playwright portal. This enables faster and more efficient troubleshooting.
     */
    @JvmName("uchghekaobsdrpwt")
    public fun reporting(`value`: EnablementStatus) {
        val toBeMapped = Either.ofRight<String, EnablementStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reporting = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ucrypwaiepkjwfug")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value When enabled, Playwright client workers can connect to cloud-hosted browsers. This can increase the number of parallel workers for a test run, significantly minimizing test completion durations.
     */
    @JvmName("farnaumfqsyryeab")
    public suspend fun scalableExecution(`value`: Either<String, EnablementStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalableExecution = mapped
    }

    /**
     * @param value When enabled, Playwright client workers can connect to cloud-hosted browsers. This can increase the number of parallel workers for a test run, significantly minimizing test completion durations.
     */
    @JvmName("kksutamexutsvqll")
    public fun scalableExecution(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnablementStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scalableExecution = mapped
    }

    /**
     * @param value When enabled, Playwright client workers can connect to cloud-hosted browsers. This can increase the number of parallel workers for a test run, significantly minimizing test completion durations.
     */
    @JvmName("cbhgqbropbtchbbr")
    public fun scalableExecution(`value`: EnablementStatus) {
        val toBeMapped = Either.ofRight<String, EnablementStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scalableExecution = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ieeelefevruvjgqi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("trjpkbvbykyhjfef")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AccountArgs = AccountArgs(
        location = location,
        name = name,
        regionalAffinity = regionalAffinity,
        reporting = reporting,
        resourceGroupName = resourceGroupName,
        scalableExecution = scalableExecution,
        tags = tags,
    )
}
