@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Operating system feed type of the device group.
 */
public enum class OSFeedType(
    public val javaValue: com.pulumi.azurenative.azuresphere.enums.OSFeedType,
) : ConvertibleToJava<com.pulumi.azurenative.azuresphere.enums.OSFeedType> {
    /**
     * Retail OS feed type.
     */
    Retail(com.pulumi.azurenative.azuresphere.enums.OSFeedType.Retail),

    /**
     * Retail evaluation OS feed type.
     */
    RetailEval(com.pulumi.azurenative.azuresphere.enums.OSFeedType.RetailEval),
    ;

    override fun toJava(): com.pulumi.azurenative.azuresphere.enums.OSFeedType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azuresphere.enums.OSFeedType): OSFeedType =
            OSFeedType.values().first { it.javaValue == javaType }
    }
}
