@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Update policy of the device group.
 */
public enum class UpdatePolicy(
    public val javaValue: com.pulumi.azurenative.azuresphere.enums.UpdatePolicy,
) : ConvertibleToJava<com.pulumi.azurenative.azuresphere.enums.UpdatePolicy> {
    /**
     * Update all policy.
     */
    UpdateAll(com.pulumi.azurenative.azuresphere.enums.UpdatePolicy.UpdateAll),

    /**
     * No update for 3rd party app policy.
     */
    No3rdPartyAppUpdates(com.pulumi.azurenative.azuresphere.enums.UpdatePolicy.No3rdPartyAppUpdates),
    ;

    override fun toJava(): com.pulumi.azurenative.azuresphere.enums.UpdatePolicy = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azuresphere.enums.UpdatePolicy):
            UpdatePolicy = UpdatePolicy.values().first { it.javaValue == javaType }
    }
}
