@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Device insight report.
 * @property description Event description
 * @property deviceId Device ID
 * @property endTimestampUtc Event end timestamp
 * @property eventCategory Event category
 * @property eventClass Event class
 * @property eventCount Event count
 * @property eventType Event type
 * @property startTimestampUtc Event start timestamp
 */
public data class DeviceInsightResponse(
    public val description: String,
    public val deviceId: String,
    public val endTimestampUtc: String,
    public val eventCategory: String,
    public val eventClass: String,
    public val eventCount: Int,
    public val eventType: String,
    public val startTimestampUtc: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azuresphere.outputs.DeviceInsightResponse):
            DeviceInsightResponse = DeviceInsightResponse(
            description = javaType.description(),
            deviceId = javaType.deviceId(),
            endTimestampUtc = javaType.endTimestampUtc(),
            eventCategory = javaType.eventCategory(),
            eventClass = javaType.eventClass(),
            eventCount = javaType.eventCount(),
            eventType = javaType.eventType(),
            startTimestampUtc = javaType.startTimestampUtc(),
        )
    }
}
