@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An image resource belonging to a catalog resource.
 * @property componentId The image component id.
 * @property description The image description.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property image Image as a UTF-8 encoded base 64 string on image create. This field contains the image URI on image reads.
 * @property imageId Image ID
 * @property imageName Image name
 * @property imageType The image type.
 * @property name The name of the resource
 * @property provisioningState The status of the last operation.
 * @property regionalDataBoundary Regional data boundary for an image
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property uri Location the image
 */
public data class ImageResponse(
    public val componentId: String,
    public val description: String,
    public val id: String,
    public val image: String? = null,
    public val imageId: String? = null,
    public val imageName: String,
    public val imageType: String,
    public val name: String,
    public val provisioningState: String,
    public val regionalDataBoundary: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val uri: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azuresphere.outputs.ImageResponse):
            ImageResponse = ImageResponse(
            componentId = javaType.componentId(),
            description = javaType.description(),
            id = javaType.id(),
            image = javaType.image().map({ args0 -> args0 }).orElse(null),
            imageId = javaType.imageId().map({ args0 -> args0 }).orElse(null),
            imageName = javaType.imageName(),
            imageType = javaType.imageType(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            regionalDataBoundary = javaType.regionalDataBoundary().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azuresphere.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            uri = javaType.uri(),
        )
    }
}
