@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestack.kotlin.inputs

import com.pulumi.azurenative.azurestack.inputs.GetRegistrationActivationKeyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property registrationName Name of the Azure Stack registration.
 * @property resourceGroup Name of the resource group.
 */
public data class GetRegistrationActivationKeyPlainArgs(
    public val registrationName: String,
    public val resourceGroup: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestack.inputs.GetRegistrationActivationKeyPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestack.inputs.GetRegistrationActivationKeyPlainArgs =
        com.pulumi.azurenative.azurestack.inputs.GetRegistrationActivationKeyPlainArgs.builder()
            .registrationName(registrationName.let({ args0 -> args0 }))
            .resourceGroup(resourceGroup.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRegistrationActivationKeyPlainArgs].
 */
@PulumiTagMarker
public class GetRegistrationActivationKeyPlainArgsBuilder internal constructor() {
    private var registrationName: String? = null

    private var resourceGroup: String? = null

    /**
     * @param value Name of the Azure Stack registration.
     */
    @JvmName("sailsnffwrvbsggh")
    public suspend fun registrationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registrationName = mapped
    }

    /**
     * @param value Name of the resource group.
     */
    @JvmName("qxisukbxrestrcxb")
    public suspend fun resourceGroup(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroup = mapped
    }

    internal fun build(): GetRegistrationActivationKeyPlainArgs =
        GetRegistrationActivationKeyPlainArgs(
            registrationName = registrationName ?: throw PulumiNullFieldException("registrationName"),
            resourceGroup = resourceGroup ?: throw PulumiNullFieldException("resourceGroup"),
        )
}
