@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestack.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * OS disk image.
 * @property operatingSystem OS operating system type.
 * @property sourceBlobSasUri SAS key for source blob.
 */
public data class OsDiskImageResponse(
    public val operatingSystem: String,
    public val sourceBlobSasUri: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestack.outputs.OsDiskImageResponse):
            OsDiskImageResponse = OsDiskImageResponse(
            operatingSystem = javaType.operatingSystem(),
            sourceBlobSasUri = javaType.sourceBlobSasUri(),
        )
    }
}
