@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.AzurestackhciFunctions.getArcSettingPlain
import com.pulumi.azurenative.azurestackhci.AzurestackhciFunctions.getClusterPlain
import com.pulumi.azurenative.azurestackhci.AzurestackhciFunctions.getDeploymentSettingPlain
import com.pulumi.azurenative.azurestackhci.AzurestackhciFunctions.getEdgeDevicePlain
import com.pulumi.azurenative.azurestackhci.AzurestackhciFunctions.getExtensionPlain
import com.pulumi.azurenative.azurestackhci.AzurestackhciFunctions.getGalleryImagePlain
import com.pulumi.azurenative.azurestackhci.AzurestackhciFunctions.getGuestAgentPlain
import com.pulumi.azurenative.azurestackhci.AzurestackhciFunctions.getHybridIdentityMetadatumPlain
import com.pulumi.azurenative.azurestackhci.AzurestackhciFunctions.getLogicalNetworkPlain
import com.pulumi.azurenative.azurestackhci.AzurestackhciFunctions.getMachineExtensionPlain
import com.pulumi.azurenative.azurestackhci.AzurestackhciFunctions.getMarketplaceGalleryImagePlain
import com.pulumi.azurenative.azurestackhci.AzurestackhciFunctions.getNetworkInterfacePlain
import com.pulumi.azurenative.azurestackhci.AzurestackhciFunctions.getSecuritySettingPlain
import com.pulumi.azurenative.azurestackhci.AzurestackhciFunctions.getStorageContainerPlain
import com.pulumi.azurenative.azurestackhci.AzurestackhciFunctions.getUpdatePlain
import com.pulumi.azurenative.azurestackhci.AzurestackhciFunctions.getUpdateRunPlain
import com.pulumi.azurenative.azurestackhci.AzurestackhciFunctions.getUpdateSummaryPlain
import com.pulumi.azurenative.azurestackhci.AzurestackhciFunctions.getVirtualHardDiskPlain
import com.pulumi.azurenative.azurestackhci.AzurestackhciFunctions.getVirtualMachineInstancePlain
import com.pulumi.azurenative.azurestackhci.AzurestackhciFunctions.getVirtualMachinePlain
import com.pulumi.azurenative.azurestackhci.AzurestackhciFunctions.getVirtualNetworkPlain
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetArcSettingPlainArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetArcSettingPlainArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetClusterPlainArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetClusterPlainArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetDeploymentSettingPlainArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetDeploymentSettingPlainArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetEdgeDevicePlainArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetEdgeDevicePlainArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetExtensionPlainArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetExtensionPlainArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetGalleryImagePlainArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetGalleryImagePlainArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetGuestAgentPlainArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetGuestAgentPlainArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetHybridIdentityMetadatumPlainArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetHybridIdentityMetadatumPlainArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetLogicalNetworkPlainArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetLogicalNetworkPlainArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetMachineExtensionPlainArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetMachineExtensionPlainArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetMarketplaceGalleryImagePlainArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetMarketplaceGalleryImagePlainArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetNetworkInterfacePlainArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetNetworkInterfacePlainArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetSecuritySettingPlainArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetSecuritySettingPlainArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetStorageContainerPlainArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetStorageContainerPlainArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetUpdatePlainArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetUpdatePlainArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetUpdateRunPlainArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetUpdateRunPlainArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetUpdateSummaryPlainArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetUpdateSummaryPlainArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetVirtualHardDiskPlainArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetVirtualHardDiskPlainArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetVirtualMachineInstancePlainArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetVirtualMachineInstancePlainArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetVirtualMachinePlainArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetVirtualMachinePlainArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetVirtualNetworkPlainArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GetVirtualNetworkPlainArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetArcSettingResult
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetClusterResult
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetDeploymentSettingResult
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetEdgeDeviceResult
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetExtensionResult
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetGalleryImageResult
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetGuestAgentResult
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetHybridIdentityMetadatumResult
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetLogicalNetworkResult
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetMachineExtensionResult
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetMarketplaceGalleryImageResult
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetNetworkInterfaceResult
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetSecuritySettingResult
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetStorageContainerResult
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetUpdateResult
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetUpdateRunResult
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetUpdateSummaryResult
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetVirtualHardDiskResult
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetVirtualMachineInstanceResult
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetVirtualMachineResult
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetVirtualNetworkResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetArcSettingResult.Companion.toKotlin as getArcSettingResultToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetClusterResult.Companion.toKotlin as getClusterResultToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetDeploymentSettingResult.Companion.toKotlin as getDeploymentSettingResultToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetEdgeDeviceResult.Companion.toKotlin as getEdgeDeviceResultToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetExtensionResult.Companion.toKotlin as getExtensionResultToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetGalleryImageResult.Companion.toKotlin as getGalleryImageResultToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetGuestAgentResult.Companion.toKotlin as getGuestAgentResultToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetHybridIdentityMetadatumResult.Companion.toKotlin as getHybridIdentityMetadatumResultToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetLogicalNetworkResult.Companion.toKotlin as getLogicalNetworkResultToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetMachineExtensionResult.Companion.toKotlin as getMachineExtensionResultToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetMarketplaceGalleryImageResult.Companion.toKotlin as getMarketplaceGalleryImageResultToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetNetworkInterfaceResult.Companion.toKotlin as getNetworkInterfaceResultToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetSecuritySettingResult.Companion.toKotlin as getSecuritySettingResultToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetStorageContainerResult.Companion.toKotlin as getStorageContainerResultToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetUpdateResult.Companion.toKotlin as getUpdateResultToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetUpdateRunResult.Companion.toKotlin as getUpdateRunResultToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetUpdateSummaryResult.Companion.toKotlin as getUpdateSummaryResultToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetVirtualHardDiskResult.Companion.toKotlin as getVirtualHardDiskResultToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetVirtualMachineInstanceResult.Companion.toKotlin as getVirtualMachineInstanceResultToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetVirtualMachineResult.Companion.toKotlin as getVirtualMachineResultToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GetVirtualNetworkResult.Companion.toKotlin as getVirtualNetworkResultToKotlin

public object AzurestackhciFunctions {
    /**
     * Get ArcSetting resource details of HCI Cluster.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2021-09-01-preview, 2022-12-15-preview, 2023-06-01, 2023-08-01, 2023-08-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return ArcSetting details.
     */
    public suspend fun getArcSetting(argument: GetArcSettingPlainArgs): GetArcSettingResult =
        getArcSettingResultToKotlin(getArcSettingPlain(argument.toJava()).await())

    /**
     * @see [getArcSetting].
     * @param arcSettingName The name of the proxy resource holding details of HCI ArcSetting information.
     * @param clusterName The name of the cluster.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return ArcSetting details.
     */
    public suspend fun getArcSetting(
        arcSettingName: String,
        clusterName: String,
        resourceGroupName: String,
    ): GetArcSettingResult {
        val argument = GetArcSettingPlainArgs(
            arcSettingName = arcSettingName,
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return getArcSettingResultToKotlin(getArcSettingPlain(argument.toJava()).await())
    }

    /**
     * @see [getArcSetting].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestackhci&#46;kotlin&#46;inputs&#46;GetArcSettingPlainArgs].
     * @return ArcSetting details.
     */
    public suspend fun getArcSetting(argument: suspend GetArcSettingPlainArgsBuilder.() -> Unit):
        GetArcSettingResult {
        val builder = GetArcSettingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getArcSettingResultToKotlin(getArcSettingPlain(builtArgument.toJava()).await())
    }

    /**
     * Get HCI cluster.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2022-01-01, 2022-09-01, 2022-12-15-preview, 2023-06-01, 2023-08-01, 2023-08-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Cluster details.
     */
    public suspend fun getCluster(argument: GetClusterPlainArgs): GetClusterResult =
        getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())

    /**
     * @see [getCluster].
     * @param clusterName The name of the cluster.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Cluster details.
     */
    public suspend fun getCluster(clusterName: String, resourceGroupName: String): GetClusterResult {
        val argument = GetClusterPlainArgs(
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getCluster].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestackhci&#46;kotlin&#46;inputs&#46;GetClusterPlainArgs].
     * @return Cluster details.
     */
    public suspend fun getCluster(argument: suspend GetClusterPlainArgsBuilder.() -> Unit):
        GetClusterResult {
        val builder = GetClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterResultToKotlin(getClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DeploymentSetting
     * Azure REST API version: 2023-08-01-preview.
     * Other available API versions: 2023-11-01-preview.
     * @param argument null
     * @return Edge device resource
     */
    public suspend fun getDeploymentSetting(argument: GetDeploymentSettingPlainArgs):
        GetDeploymentSettingResult =
        getDeploymentSettingResultToKotlin(getDeploymentSettingPlain(argument.toJava()).await())

    /**
     * @see [getDeploymentSetting].
     * @param clusterName The name of the cluster.
     * @param deploymentSettingsName Name of Deployment Setting
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Edge device resource
     */
    public suspend fun getDeploymentSetting(
        clusterName: String,
        deploymentSettingsName: String,
        resourceGroupName: String,
    ): GetDeploymentSettingResult {
        val argument = GetDeploymentSettingPlainArgs(
            clusterName = clusterName,
            deploymentSettingsName = deploymentSettingsName,
            resourceGroupName = resourceGroupName,
        )
        return getDeploymentSettingResultToKotlin(getDeploymentSettingPlain(argument.toJava()).await())
    }

    /**
     * @see [getDeploymentSetting].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestackhci&#46;kotlin&#46;inputs&#46;GetDeploymentSettingPlainArgs].
     * @return Edge device resource
     */
    public suspend
    fun getDeploymentSetting(argument: suspend GetDeploymentSettingPlainArgsBuilder.() -> Unit):
        GetDeploymentSettingResult {
        val builder = GetDeploymentSettingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDeploymentSettingResultToKotlin(getDeploymentSettingPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a EdgeDevice
     * Azure REST API version: 2023-08-01-preview.
     * Other available API versions: 2023-11-01-preview.
     * @param argument null
     * @return Edge device resource
     */
    public suspend fun getEdgeDevice(argument: GetEdgeDevicePlainArgs): GetEdgeDeviceResult =
        getEdgeDeviceResultToKotlin(getEdgeDevicePlain(argument.toJava()).await())

    /**
     * @see [getEdgeDevice].
     * @param edgeDeviceName Name of Device
     * @param resourceUri The fully qualified Azure Resource manager identifier of the resource.
     * @return Edge device resource
     */
    public suspend fun getEdgeDevice(edgeDeviceName: String, resourceUri: String):
        GetEdgeDeviceResult {
        val argument = GetEdgeDevicePlainArgs(
            edgeDeviceName = edgeDeviceName,
            resourceUri = resourceUri,
        )
        return getEdgeDeviceResultToKotlin(getEdgeDevicePlain(argument.toJava()).await())
    }

    /**
     * @see [getEdgeDevice].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestackhci&#46;kotlin&#46;inputs&#46;GetEdgeDevicePlainArgs].
     * @return Edge device resource
     */
    public suspend fun getEdgeDevice(argument: suspend GetEdgeDevicePlainArgsBuilder.() -> Unit):
        GetEdgeDeviceResult {
        val builder = GetEdgeDevicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEdgeDeviceResultToKotlin(getEdgeDevicePlain(builtArgument.toJava()).await())
    }

    /**
     * Get particular Arc Extension of HCI Cluster.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2022-12-15-preview, 2023-06-01, 2023-08-01, 2023-08-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Details of a particular extension in HCI Cluster.
     */
    public suspend fun getExtension(argument: GetExtensionPlainArgs): GetExtensionResult =
        getExtensionResultToKotlin(getExtensionPlain(argument.toJava()).await())

    /**
     * @see [getExtension].
     * @param arcSettingName The name of the proxy resource holding details of HCI ArcSetting information.
     * @param clusterName The name of the cluster.
     * @param extensionName The name of the machine extension.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Details of a particular extension in HCI Cluster.
     */
    public suspend fun getExtension(
        arcSettingName: String,
        clusterName: String,
        extensionName: String,
        resourceGroupName: String,
    ): GetExtensionResult {
        val argument = GetExtensionPlainArgs(
            arcSettingName = arcSettingName,
            clusterName = clusterName,
            extensionName = extensionName,
            resourceGroupName = resourceGroupName,
        )
        return getExtensionResultToKotlin(getExtensionPlain(argument.toJava()).await())
    }

    /**
     * @see [getExtension].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestackhci&#46;kotlin&#46;inputs&#46;GetExtensionPlainArgs].
     * @return Details of a particular extension in HCI Cluster.
     */
    public suspend fun getExtension(argument: suspend GetExtensionPlainArgsBuilder.() -> Unit):
        GetExtensionResult {
        val builder = GetExtensionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getExtensionResultToKotlin(getExtensionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a gallery image
     * Azure REST API version: 2022-12-15-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview.
     * @param argument null
     * @return The gallery images resource definition.
     */
    public suspend fun getGalleryImage(argument: GetGalleryImagePlainArgs): GetGalleryImageResult =
        getGalleryImageResultToKotlin(getGalleryImagePlain(argument.toJava()).await())

    /**
     * @see [getGalleryImage].
     * @param galleryImageName Name of the gallery image
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The gallery images resource definition.
     */
    public suspend fun getGalleryImage(galleryImageName: String, resourceGroupName: String):
        GetGalleryImageResult {
        val argument = GetGalleryImagePlainArgs(
            galleryImageName = galleryImageName,
            resourceGroupName = resourceGroupName,
        )
        return getGalleryImageResultToKotlin(getGalleryImagePlain(argument.toJava()).await())
    }

    /**
     * @see [getGalleryImage].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestackhci&#46;kotlin&#46;inputs&#46;GetGalleryImagePlainArgs].
     * @return The gallery images resource definition.
     */
    public suspend fun getGalleryImage(argument: suspend GetGalleryImagePlainArgsBuilder.() -> Unit):
        GetGalleryImageResult {
        val builder = GetGalleryImagePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGalleryImageResultToKotlin(getGalleryImagePlain(builtArgument.toJava()).await())
    }

    /**
     * Implements GuestAgent GET method.
     * Azure REST API version: 2022-12-15-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview.
     * @param argument null
     * @return Defines the GuestAgent.
     */
    public suspend fun getGuestAgent(argument: GetGuestAgentPlainArgs): GetGuestAgentResult =
        getGuestAgentResultToKotlin(getGuestAgentPlain(argument.toJava()).await())

    /**
     * @see [getGuestAgent].
     * @param name Name of the GuestAgent.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param virtualMachineName Name of the vm.
     * @return Defines the GuestAgent.
     */
    public suspend fun getGuestAgent(
        name: String,
        resourceGroupName: String,
        virtualMachineName: String,
    ): GetGuestAgentResult {
        val argument = GetGuestAgentPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            virtualMachineName = virtualMachineName,
        )
        return getGuestAgentResultToKotlin(getGuestAgentPlain(argument.toJava()).await())
    }

    /**
     * @see [getGuestAgent].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestackhci&#46;kotlin&#46;inputs&#46;GetGuestAgentPlainArgs].
     * @return Defines the GuestAgent.
     */
    public suspend fun getGuestAgent(argument: suspend GetGuestAgentPlainArgsBuilder.() -> Unit):
        GetGuestAgentResult {
        val builder = GetGuestAgentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGuestAgentResultToKotlin(getGuestAgentPlain(builtArgument.toJava()).await())
    }

    /**
     * Implements HybridIdentityMetadata GET method.
     * Azure REST API version: 2022-12-15-preview.
     * @param argument null
     * @return Defines the HybridIdentityMetadata.
     */
    public suspend fun getHybridIdentityMetadatum(argument: GetHybridIdentityMetadatumPlainArgs):
        GetHybridIdentityMetadatumResult =
        getHybridIdentityMetadatumResultToKotlin(getHybridIdentityMetadatumPlain(argument.toJava()).await())

    /**
     * @see [getHybridIdentityMetadatum].
     * @param metadataName Name of the HybridIdentityMetadata.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param virtualMachineName Name of the vm.
     * @return Defines the HybridIdentityMetadata.
     */
    public suspend fun getHybridIdentityMetadatum(
        metadataName: String,
        resourceGroupName: String,
        virtualMachineName: String,
    ): GetHybridIdentityMetadatumResult {
        val argument = GetHybridIdentityMetadatumPlainArgs(
            metadataName = metadataName,
            resourceGroupName = resourceGroupName,
            virtualMachineName = virtualMachineName,
        )
        return getHybridIdentityMetadatumResultToKotlin(getHybridIdentityMetadatumPlain(argument.toJava()).await())
    }

    /**
     * @see [getHybridIdentityMetadatum].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestackhci&#46;kotlin&#46;inputs&#46;GetHybridIdentityMetadatumPlainArgs].
     * @return Defines the HybridIdentityMetadata.
     */
    public suspend
    fun getHybridIdentityMetadatum(argument: suspend GetHybridIdentityMetadatumPlainArgsBuilder.() -> Unit):
        GetHybridIdentityMetadatumResult {
        val builder = GetHybridIdentityMetadatumPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHybridIdentityMetadatumResultToKotlin(getHybridIdentityMetadatumPlain(builtArgument.toJava()).await())
    }

    /**
     * The logical network resource definition.
     * Azure REST API version: 2023-09-01-preview.
     * @param argument null
     * @return The logical network resource definition.
     */
    public suspend fun getLogicalNetwork(argument: GetLogicalNetworkPlainArgs):
        GetLogicalNetworkResult =
        getLogicalNetworkResultToKotlin(getLogicalNetworkPlain(argument.toJava()).await())

    /**
     * @see [getLogicalNetwork].
     * @param logicalNetworkName Name of the logical network
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The logical network resource definition.
     */
    public suspend fun getLogicalNetwork(logicalNetworkName: String, resourceGroupName: String):
        GetLogicalNetworkResult {
        val argument = GetLogicalNetworkPlainArgs(
            logicalNetworkName = logicalNetworkName,
            resourceGroupName = resourceGroupName,
        )
        return getLogicalNetworkResultToKotlin(getLogicalNetworkPlain(argument.toJava()).await())
    }

    /**
     * @see [getLogicalNetwork].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestackhci&#46;kotlin&#46;inputs&#46;GetLogicalNetworkPlainArgs].
     * @return The logical network resource definition.
     */
    public suspend
    fun getLogicalNetwork(argument: suspend GetLogicalNetworkPlainArgsBuilder.() -> Unit):
        GetLogicalNetworkResult {
        val builder = GetLogicalNetworkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLogicalNetworkResultToKotlin(getLogicalNetworkPlain(builtArgument.toJava()).await())
    }

    /**
     * The operation to get the extension.
     * Azure REST API version: 2022-12-15-preview.
     * @param argument null
     * @return Describes a Machine Extension.
     */
    public suspend fun getMachineExtension(argument: GetMachineExtensionPlainArgs):
        GetMachineExtensionResult =
        getMachineExtensionResultToKotlin(getMachineExtensionPlain(argument.toJava()).await())

    /**
     * @see [getMachineExtension].
     * @param extensionName The name of the machine extension.
     * @param name The name of the machine containing the extension.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Describes a Machine Extension.
     */
    public suspend fun getMachineExtension(
        extensionName: String,
        name: String,
        resourceGroupName: String,
    ): GetMachineExtensionResult {
        val argument = GetMachineExtensionPlainArgs(
            extensionName = extensionName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getMachineExtensionResultToKotlin(getMachineExtensionPlain(argument.toJava()).await())
    }

    /**
     * @see [getMachineExtension].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestackhci&#46;kotlin&#46;inputs&#46;GetMachineExtensionPlainArgs].
     * @return Describes a Machine Extension.
     */
    public suspend
    fun getMachineExtension(argument: suspend GetMachineExtensionPlainArgsBuilder.() -> Unit):
        GetMachineExtensionResult {
        val builder = GetMachineExtensionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMachineExtensionResultToKotlin(getMachineExtensionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a marketplace gallery image
     * Azure REST API version: 2022-12-15-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview.
     * @param argument null
     * @return The marketplace gallery image resource definition.
     */
    public suspend fun getMarketplaceGalleryImage(argument: GetMarketplaceGalleryImagePlainArgs):
        GetMarketplaceGalleryImageResult =
        getMarketplaceGalleryImageResultToKotlin(getMarketplaceGalleryImagePlain(argument.toJava()).await())

    /**
     * @see [getMarketplaceGalleryImage].
     * @param marketplaceGalleryImageName Name of the marketplace gallery image
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The marketplace gallery image resource definition.
     */
    public suspend fun getMarketplaceGalleryImage(
        marketplaceGalleryImageName: String,
        resourceGroupName: String,
    ): GetMarketplaceGalleryImageResult {
        val argument = GetMarketplaceGalleryImagePlainArgs(
            marketplaceGalleryImageName = marketplaceGalleryImageName,
            resourceGroupName = resourceGroupName,
        )
        return getMarketplaceGalleryImageResultToKotlin(getMarketplaceGalleryImagePlain(argument.toJava()).await())
    }

    /**
     * @see [getMarketplaceGalleryImage].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestackhci&#46;kotlin&#46;inputs&#46;GetMarketplaceGalleryImagePlainArgs].
     * @return The marketplace gallery image resource definition.
     */
    public suspend
    fun getMarketplaceGalleryImage(argument: suspend GetMarketplaceGalleryImagePlainArgsBuilder.() -> Unit):
        GetMarketplaceGalleryImageResult {
        val builder = GetMarketplaceGalleryImagePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMarketplaceGalleryImageResultToKotlin(getMarketplaceGalleryImagePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a network interface
     * Azure REST API version: 2022-12-15-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview.
     * @param argument null
     * @return The network interface resource definition.
     */
    public suspend fun getNetworkInterface(argument: GetNetworkInterfacePlainArgs):
        GetNetworkInterfaceResult =
        getNetworkInterfaceResultToKotlin(getNetworkInterfacePlain(argument.toJava()).await())

    /**
     * @see [getNetworkInterface].
     * @param networkInterfaceName Name of the network interface
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The network interface resource definition.
     */
    public suspend fun getNetworkInterface(networkInterfaceName: String, resourceGroupName: String):
        GetNetworkInterfaceResult {
        val argument = GetNetworkInterfacePlainArgs(
            networkInterfaceName = networkInterfaceName,
            resourceGroupName = resourceGroupName,
        )
        return getNetworkInterfaceResultToKotlin(getNetworkInterfacePlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkInterface].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestackhci&#46;kotlin&#46;inputs&#46;GetNetworkInterfacePlainArgs].
     * @return The network interface resource definition.
     */
    public suspend
    fun getNetworkInterface(argument: suspend GetNetworkInterfacePlainArgsBuilder.() -> Unit):
        GetNetworkInterfaceResult {
        val builder = GetNetworkInterfacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkInterfaceResultToKotlin(getNetworkInterfacePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a SecuritySetting
     * Azure REST API version: 2023-11-01-preview.
     * @param argument null
     * @return Security settings proxy resource
     */
    public suspend fun getSecuritySetting(argument: GetSecuritySettingPlainArgs):
        GetSecuritySettingResult =
        getSecuritySettingResultToKotlin(getSecuritySettingPlain(argument.toJava()).await())

    /**
     * @see [getSecuritySetting].
     * @param clusterName The name of the cluster.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param securitySettingsName Name of security setting
     * @return Security settings proxy resource
     */
    public suspend fun getSecuritySetting(
        clusterName: String,
        resourceGroupName: String,
        securitySettingsName: String,
    ): GetSecuritySettingResult {
        val argument = GetSecuritySettingPlainArgs(
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
            securitySettingsName = securitySettingsName,
        )
        return getSecuritySettingResultToKotlin(getSecuritySettingPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecuritySetting].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestackhci&#46;kotlin&#46;inputs&#46;GetSecuritySettingPlainArgs].
     * @return Security settings proxy resource
     */
    public suspend
    fun getSecuritySetting(argument: suspend GetSecuritySettingPlainArgsBuilder.() -> Unit):
        GetSecuritySettingResult {
        val builder = GetSecuritySettingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecuritySettingResultToKotlin(getSecuritySettingPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a storage container
     * Azure REST API version: 2022-12-15-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview.
     * @param argument null
     * @return The storage container resource definition.
     */
    public suspend fun getStorageContainer(argument: GetStorageContainerPlainArgs):
        GetStorageContainerResult =
        getStorageContainerResultToKotlin(getStorageContainerPlain(argument.toJava()).await())

    /**
     * @see [getStorageContainer].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param storageContainerName Name of the storage container
     * @return The storage container resource definition.
     */
    public suspend fun getStorageContainer(resourceGroupName: String, storageContainerName: String):
        GetStorageContainerResult {
        val argument = GetStorageContainerPlainArgs(
            resourceGroupName = resourceGroupName,
            storageContainerName = storageContainerName,
        )
        return getStorageContainerResultToKotlin(getStorageContainerPlain(argument.toJava()).await())
    }

    /**
     * @see [getStorageContainer].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestackhci&#46;kotlin&#46;inputs&#46;GetStorageContainerPlainArgs].
     * @return The storage container resource definition.
     */
    public suspend
    fun getStorageContainer(argument: suspend GetStorageContainerPlainArgsBuilder.() -> Unit):
        GetStorageContainerResult {
        val builder = GetStorageContainerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStorageContainerResultToKotlin(getStorageContainerPlain(builtArgument.toJava()).await())
    }

    /**
     * Get specified Update
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2022-12-15-preview, 2023-06-01, 2023-08-01, 2023-08-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Update details
     */
    public suspend fun getUpdate(argument: GetUpdatePlainArgs): GetUpdateResult =
        getUpdateResultToKotlin(getUpdatePlain(argument.toJava()).await())

    /**
     * @see [getUpdate].
     * @param clusterName The name of the cluster.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param updateName The name of the Update
     * @return Update details
     */
    public suspend fun getUpdate(
        clusterName: String,
        resourceGroupName: String,
        updateName: String,
    ): GetUpdateResult {
        val argument = GetUpdatePlainArgs(
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
            updateName = updateName,
        )
        return getUpdateResultToKotlin(getUpdatePlain(argument.toJava()).await())
    }

    /**
     * @see [getUpdate].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestackhci&#46;kotlin&#46;inputs&#46;GetUpdatePlainArgs].
     * @return Update details
     */
    public suspend fun getUpdate(argument: suspend GetUpdatePlainArgsBuilder.() -> Unit):
        GetUpdateResult {
        val builder = GetUpdatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUpdateResultToKotlin(getUpdatePlain(builtArgument.toJava()).await())
    }

    /**
     * Get the Update run for a specified update
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2022-12-15-preview, 2023-06-01, 2023-08-01, 2023-08-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Details of an Update run
     */
    public suspend fun getUpdateRun(argument: GetUpdateRunPlainArgs): GetUpdateRunResult =
        getUpdateRunResultToKotlin(getUpdateRunPlain(argument.toJava()).await())

    /**
     * @see [getUpdateRun].
     * @param clusterName The name of the cluster.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param updateName The name of the Update
     * @param updateRunName The name of the Update Run
     * @return Details of an Update run
     */
    public suspend fun getUpdateRun(
        clusterName: String,
        resourceGroupName: String,
        updateName: String,
        updateRunName: String,
    ): GetUpdateRunResult {
        val argument = GetUpdateRunPlainArgs(
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
            updateName = updateName,
            updateRunName = updateRunName,
        )
        return getUpdateRunResultToKotlin(getUpdateRunPlain(argument.toJava()).await())
    }

    /**
     * @see [getUpdateRun].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestackhci&#46;kotlin&#46;inputs&#46;GetUpdateRunPlainArgs].
     * @return Details of an Update run
     */
    public suspend fun getUpdateRun(argument: suspend GetUpdateRunPlainArgsBuilder.() -> Unit):
        GetUpdateRunResult {
        val builder = GetUpdateRunPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUpdateRunResultToKotlin(getUpdateRunPlain(builtArgument.toJava()).await())
    }

    /**
     * Get all Update summaries under the HCI cluster
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2022-12-15-preview, 2023-06-01, 2023-08-01, 2023-08-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Get the update summaries for the cluster
     */
    public suspend fun getUpdateSummary(argument: GetUpdateSummaryPlainArgs): GetUpdateSummaryResult =
        getUpdateSummaryResultToKotlin(getUpdateSummaryPlain(argument.toJava()).await())

    /**
     * @see [getUpdateSummary].
     * @param clusterName The name of the cluster.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Get the update summaries for the cluster
     */
    public suspend fun getUpdateSummary(clusterName: String, resourceGroupName: String):
        GetUpdateSummaryResult {
        val argument = GetUpdateSummaryPlainArgs(
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return getUpdateSummaryResultToKotlin(getUpdateSummaryPlain(argument.toJava()).await())
    }

    /**
     * @see [getUpdateSummary].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestackhci&#46;kotlin&#46;inputs&#46;GetUpdateSummaryPlainArgs].
     * @return Get the update summaries for the cluster
     */
    public suspend
    fun getUpdateSummary(argument: suspend GetUpdateSummaryPlainArgsBuilder.() -> Unit):
        GetUpdateSummaryResult {
        val builder = GetUpdateSummaryPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUpdateSummaryResultToKotlin(getUpdateSummaryPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a virtual hard disk
     * Azure REST API version: 2022-12-15-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview.
     * @param argument null
     * @return The virtual hard disk resource definition.
     */
    public suspend fun getVirtualHardDisk(argument: GetVirtualHardDiskPlainArgs):
        GetVirtualHardDiskResult =
        getVirtualHardDiskResultToKotlin(getVirtualHardDiskPlain(argument.toJava()).await())

    /**
     * @see [getVirtualHardDisk].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param virtualHardDiskName Name of the virtual hard disk
     * @return The virtual hard disk resource definition.
     */
    public suspend fun getVirtualHardDisk(resourceGroupName: String, virtualHardDiskName: String):
        GetVirtualHardDiskResult {
        val argument = GetVirtualHardDiskPlainArgs(
            resourceGroupName = resourceGroupName,
            virtualHardDiskName = virtualHardDiskName,
        )
        return getVirtualHardDiskResultToKotlin(getVirtualHardDiskPlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualHardDisk].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestackhci&#46;kotlin&#46;inputs&#46;GetVirtualHardDiskPlainArgs].
     * @return The virtual hard disk resource definition.
     */
    public suspend
    fun getVirtualHardDisk(argument: suspend GetVirtualHardDiskPlainArgsBuilder.() -> Unit):
        GetVirtualHardDiskResult {
        val builder = GetVirtualHardDiskPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualHardDiskResultToKotlin(getVirtualHardDiskPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a virtual machine
     * Azure REST API version: 2022-12-15-preview.
     * @param argument null
     * @return The virtual machine resource definition.
     */
    public suspend fun getVirtualMachine(argument: GetVirtualMachinePlainArgs):
        GetVirtualMachineResult =
        getVirtualMachineResultToKotlin(getVirtualMachinePlain(argument.toJava()).await())

    /**
     * @see [getVirtualMachine].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param virtualMachineName Name of the virtual machine
     * @return The virtual machine resource definition.
     */
    public suspend fun getVirtualMachine(resourceGroupName: String, virtualMachineName: String):
        GetVirtualMachineResult {
        val argument = GetVirtualMachinePlainArgs(
            resourceGroupName = resourceGroupName,
            virtualMachineName = virtualMachineName,
        )
        return getVirtualMachineResultToKotlin(getVirtualMachinePlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualMachine].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestackhci&#46;kotlin&#46;inputs&#46;GetVirtualMachinePlainArgs].
     * @return The virtual machine resource definition.
     */
    public suspend
    fun getVirtualMachine(argument: suspend GetVirtualMachinePlainArgsBuilder.() -> Unit):
        GetVirtualMachineResult {
        val builder = GetVirtualMachinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualMachineResultToKotlin(getVirtualMachinePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a virtual machine instance
     * Azure REST API version: 2023-07-01-preview.
     * Other available API versions: 2023-09-01-preview.
     * @param argument null
     * @return The virtual machine instance resource definition.
     */
    public suspend fun getVirtualMachineInstance(argument: GetVirtualMachineInstancePlainArgs):
        GetVirtualMachineInstanceResult =
        getVirtualMachineInstanceResultToKotlin(getVirtualMachineInstancePlain(argument.toJava()).await())

    /**
     * @see [getVirtualMachineInstance].
     * @param resourceUri The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
     * @return The virtual machine instance resource definition.
     */
    public suspend fun getVirtualMachineInstance(resourceUri: String):
        GetVirtualMachineInstanceResult {
        val argument = GetVirtualMachineInstancePlainArgs(
            resourceUri = resourceUri,
        )
        return getVirtualMachineInstanceResultToKotlin(getVirtualMachineInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualMachineInstance].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestackhci&#46;kotlin&#46;inputs&#46;GetVirtualMachineInstancePlainArgs].
     * @return The virtual machine instance resource definition.
     */
    public suspend
    fun getVirtualMachineInstance(argument: suspend GetVirtualMachineInstancePlainArgsBuilder.() -> Unit):
        GetVirtualMachineInstanceResult {
        val builder = GetVirtualMachineInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualMachineInstanceResultToKotlin(getVirtualMachineInstancePlain(builtArgument.toJava()).await())
    }

    /**
     * The virtual network resource definition.
     * Azure REST API version: 2022-12-15-preview.
     * Other available API versions: 2023-07-01-preview.
     * @param argument null
     * @return The virtual network resource definition.
     */
    public suspend fun getVirtualNetwork(argument: GetVirtualNetworkPlainArgs):
        GetVirtualNetworkResult =
        getVirtualNetworkResultToKotlin(getVirtualNetworkPlain(argument.toJava()).await())

    /**
     * @see [getVirtualNetwork].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param virtualNetworkName Name of the virtual network
     * @return The virtual network resource definition.
     */
    public suspend fun getVirtualNetwork(resourceGroupName: String, virtualNetworkName: String):
        GetVirtualNetworkResult {
        val argument = GetVirtualNetworkPlainArgs(
            resourceGroupName = resourceGroupName,
            virtualNetworkName = virtualNetworkName,
        )
        return getVirtualNetworkResultToKotlin(getVirtualNetworkPlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualNetwork].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurestackhci&#46;kotlin&#46;inputs&#46;GetVirtualNetworkPlainArgs].
     * @return The virtual network resource definition.
     */
    public suspend
    fun getVirtualNetwork(argument: suspend GetVirtualNetworkPlainArgsBuilder.() -> Unit):
        GetVirtualNetworkResult {
        val builder = GetVirtualNetworkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualNetworkResultToKotlin(getVirtualNetworkPlain(builtArgument.toJava()).await())
    }
}
