@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.ClusterArgs.builder
import com.pulumi.azurenative.azurestackhci.kotlin.enums.ManagedServiceIdentityType
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.ClusterDesiredPropertiesArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.ClusterDesiredPropertiesArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.SoftwareAssurancePropertiesArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.SoftwareAssurancePropertiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Cluster details.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2020-10-01.
 * Other available API versions: 2022-01-01, 2022-09-01, 2022-12-15-preview, 2023-06-01, 2023-08-01, 2023-08-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### Create cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.AzureStackHCI.Cluster("cluster", new()
 *     {
 *         AadClientId = "24a6e53d-04e5-44d2-b7cc-1b732a847dfc",
 *         AadTenantId = "7e589cc1-a8b6-4dff-91bd-5ec0fa18db94",
 *         CloudManagementEndpoint = "https://98294836-31be-4668-aeae-698667faf99b.waconazure.com",
 *         ClusterName = "myCluster",
 *         Location = "East US",
 *         ResourceGroupName = "test-rg",
 *         Type = "SystemAssigned",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewCluster(ctx, "cluster", &azurestackhci.ClusterArgs{
 * 			AadClientId:             pulumi.String("24a6e53d-04e5-44d2-b7cc-1b732a847dfc"),
 * 			AadTenantId:             pulumi.String("7e589cc1-a8b6-4dff-91bd-5ec0fa18db94"),
 * 			CloudManagementEndpoint: pulumi.String("https://98294836-31be-4668-aeae-698667faf99b.waconazure.com"),
 * 			ClusterName:             pulumi.String("myCluster"),
 * 			Location:                pulumi.String("East US"),
 * 			ResourceGroupName:       pulumi.String("test-rg"),
 * 			Type:                    pulumi.String("SystemAssigned"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.Cluster;
 * import com.pulumi.azurenative.azurestackhci.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .aadClientId("24a6e53d-04e5-44d2-b7cc-1b732a847dfc")
 *             .aadTenantId("7e589cc1-a8b6-4dff-91bd-5ec0fa18db94")
 *             .cloudManagementEndpoint("https://98294836-31be-4668-aeae-698667faf99b.waconazure.com")
 *             .clusterName("myCluster")
 *             .location("East US")
 *             .resourceGroupName("test-rg")
 *             .type("SystemAssigned")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:Cluster myCluster /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}
 * ```
 * @property aadApplicationObjectId Object id of cluster AAD identity.
 * @property aadClientId App id of cluster AAD identity.
 * @property aadServicePrincipalObjectId Id of cluster identity service principal.
 * @property aadTenantId Tenant id of cluster AAD identity.
 * @property cloudManagementEndpoint Endpoint configured for management from the Azure portal.
 * @property clusterName The name of the cluster.
 * @property desiredProperties Desired properties of the cluster.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property softwareAssuranceProperties Software Assurance properties of the cluster.
 * @property tags Resource tags.
 * @property type Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
 * @property userAssignedIdentities The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
 */
public data class ClusterArgs(
    public val aadApplicationObjectId: Output<String>? = null,
    public val aadClientId: Output<String>? = null,
    public val aadServicePrincipalObjectId: Output<String>? = null,
    public val aadTenantId: Output<String>? = null,
    public val cloudManagementEndpoint: Output<String>? = null,
    public val clusterName: Output<String>? = null,
    public val desiredProperties: Output<ClusterDesiredPropertiesArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val softwareAssuranceProperties: Output<SoftwareAssurancePropertiesArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<Either<String, ManagedServiceIdentityType>>? = null,
    public val userAssignedIdentities: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.ClusterArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.ClusterArgs =
        com.pulumi.azurenative.azurestackhci.ClusterArgs.builder()
            .aadApplicationObjectId(aadApplicationObjectId?.applyValue({ args0 -> args0 }))
            .aadClientId(aadClientId?.applyValue({ args0 -> args0 }))
            .aadServicePrincipalObjectId(aadServicePrincipalObjectId?.applyValue({ args0 -> args0 }))
            .aadTenantId(aadTenantId?.applyValue({ args0 -> args0 }))
            .cloudManagementEndpoint(cloudManagementEndpoint?.applyValue({ args0 -> args0 }))
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .desiredProperties(desiredProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .softwareAssuranceProperties(
                softwareAssuranceProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var aadApplicationObjectId: Output<String>? = null

    private var aadClientId: Output<String>? = null

    private var aadServicePrincipalObjectId: Output<String>? = null

    private var aadTenantId: Output<String>? = null

    private var cloudManagementEndpoint: Output<String>? = null

    private var clusterName: Output<String>? = null

    private var desiredProperties: Output<ClusterDesiredPropertiesArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var softwareAssuranceProperties: Output<SoftwareAssurancePropertiesArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<Either<String, ManagedServiceIdentityType>>? = null

    private var userAssignedIdentities: Output<List<String>>? = null

    /**
     * @param value Object id of cluster AAD identity.
     */
    @JvmName("wvrykgeskpyseahd")
    public suspend fun aadApplicationObjectId(`value`: Output<String>) {
        this.aadApplicationObjectId = value
    }

    /**
     * @param value App id of cluster AAD identity.
     */
    @JvmName("nqbxikgjfmjiveas")
    public suspend fun aadClientId(`value`: Output<String>) {
        this.aadClientId = value
    }

    /**
     * @param value Id of cluster identity service principal.
     */
    @JvmName("bhnwnpfipbittfox")
    public suspend fun aadServicePrincipalObjectId(`value`: Output<String>) {
        this.aadServicePrincipalObjectId = value
    }

    /**
     * @param value Tenant id of cluster AAD identity.
     */
    @JvmName("mrwaepbwarluexca")
    public suspend fun aadTenantId(`value`: Output<String>) {
        this.aadTenantId = value
    }

    /**
     * @param value Endpoint configured for management from the Azure portal.
     */
    @JvmName("gaovypmawpxwnjol")
    public suspend fun cloudManagementEndpoint(`value`: Output<String>) {
        this.cloudManagementEndpoint = value
    }

    /**
     * @param value The name of the cluster.
     */
    @JvmName("ptetacgvnwdchwef")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Desired properties of the cluster.
     */
    @JvmName("lyrndksykuwoovvh")
    public suspend fun desiredProperties(`value`: Output<ClusterDesiredPropertiesArgs>) {
        this.desiredProperties = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ewolxyakmietvedh")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jnslihokdgivstck")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Software Assurance properties of the cluster.
     */
    @JvmName("bqysplmcaedcpafn")
    public suspend fun softwareAssuranceProperties(`value`: Output<SoftwareAssurancePropertiesArgs>) {
        this.softwareAssuranceProperties = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qrmfjiehqfqfrgxw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
     */
    @JvmName("rvmlujojfhyfuirx")
    public suspend fun type(`value`: Output<Either<String, ManagedServiceIdentityType>>) {
        this.type = value
    }

    /**
     * @param value The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
     */
    @JvmName("hjsbwmaufgrojkql")
    public suspend fun userAssignedIdentities(`value`: Output<List<String>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("wqowxwmagwrtagip")
    public suspend fun userAssignedIdentities(vararg values: Output<String>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
     */
    @JvmName("gcqubxlpksiqfswl")
    public suspend fun userAssignedIdentities(values: List<Output<String>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value Object id of cluster AAD identity.
     */
    @JvmName("pabfqrcgnxdnfknr")
    public suspend fun aadApplicationObjectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadApplicationObjectId = mapped
    }

    /**
     * @param value App id of cluster AAD identity.
     */
    @JvmName("exsaqcickapefung")
    public suspend fun aadClientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadClientId = mapped
    }

    /**
     * @param value Id of cluster identity service principal.
     */
    @JvmName("phpreyxqwcbmpqrv")
    public suspend fun aadServicePrincipalObjectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadServicePrincipalObjectId = mapped
    }

    /**
     * @param value Tenant id of cluster AAD identity.
     */
    @JvmName("dgdlhanthuckvigp")
    public suspend fun aadTenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadTenantId = mapped
    }

    /**
     * @param value Endpoint configured for management from the Azure portal.
     */
    @JvmName("kbxrrjcstvnodaph")
    public suspend fun cloudManagementEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudManagementEndpoint = mapped
    }

    /**
     * @param value The name of the cluster.
     */
    @JvmName("gjgpwadkqcxhxxfu")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Desired properties of the cluster.
     */
    @JvmName("tokufckvfkfcrwnt")
    public suspend fun desiredProperties(`value`: ClusterDesiredPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredProperties = mapped
    }

    /**
     * @param argument Desired properties of the cluster.
     */
    @JvmName("btqgvwmgonvusmfx")
    public suspend
    fun desiredProperties(argument: suspend ClusterDesiredPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterDesiredPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.desiredProperties = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("bchsqceseriamrsy")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("aolyaprdopxongcx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Software Assurance properties of the cluster.
     */
    @JvmName("blcglbhybltrjbwn")
    public suspend fun softwareAssuranceProperties(`value`: SoftwareAssurancePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softwareAssuranceProperties = mapped
    }

    /**
     * @param argument Software Assurance properties of the cluster.
     */
    @JvmName("pbscyovhmbiompws")
    public suspend
    fun softwareAssuranceProperties(argument: suspend SoftwareAssurancePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SoftwareAssurancePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.softwareAssuranceProperties = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("uemmscleoltbxeyr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nfknhicqavuclyga")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
     */
    @JvmName("vwoanomnyeaycalp")
    public suspend fun type(`value`: Either<String, ManagedServiceIdentityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
     */
    @JvmName("sssdsdncfkmwmckn")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedServiceIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
     */
    @JvmName("kfaqcnaaxneqduyw")
    public fun type(`value`: ManagedServiceIdentityType) {
        val toBeMapped = Either.ofRight<String, ManagedServiceIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
     */
    @JvmName("lyecgijauvhxkphs")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
     */
    @JvmName("lcfjakcvdwlppaxo")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        aadApplicationObjectId = aadApplicationObjectId,
        aadClientId = aadClientId,
        aadServicePrincipalObjectId = aadServicePrincipalObjectId,
        aadTenantId = aadTenantId,
        cloudManagementEndpoint = cloudManagementEndpoint,
        clusterName = clusterName,
        desiredProperties = desiredProperties,
        location = location,
        resourceGroupName = resourceGroupName,
        softwareAssuranceProperties = softwareAssuranceProperties,
        tags = tags,
        type = type,
        userAssignedIdentities = userAssignedIdentities,
    )
}
