@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.ExtensionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Details of a particular extension in HCI Cluster.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2021-01-01-preview.
 * Other available API versions: 2022-12-15-preview, 2023-06-01, 2023-08-01, 2023-08-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### Create Arc Extension
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var extension = new AzureNative.AzureStackHCI.Extension("extension", new()
 *     {
 *         ArcSettingName = "default",
 *         ClusterName = "myCluster",
 *         EnableAutomaticUpgrade = false,
 *         ExtensionName = "MicrosoftMonitoringAgent",
 *         ProtectedSettings =
 *         {
 *             { "workspaceKey", "xx" },
 *         },
 *         Publisher = "Microsoft.Compute",
 *         ResourceGroupName = "test-rg",
 *         Settings =
 *         {
 *             { "workspaceId", "xx" },
 *         },
 *         Type = "MicrosoftMonitoringAgent",
 *         TypeHandlerVersion = "1.10",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewExtension(ctx, "extension", &azurestackhci.ExtensionArgs{
 * 			ArcSettingName:         pulumi.String("default"),
 * 			ClusterName:            pulumi.String("myCluster"),
 * 			EnableAutomaticUpgrade: pulumi.Bool(false),
 * 			ExtensionName:          pulumi.String("MicrosoftMonitoringAgent"),
 * 			ProtectedSettings: pulumi.Any{
 * 				WorkspaceKey: "xx",
 * 			},
 * 			Publisher:         pulumi.String("Microsoft.Compute"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Settings: pulumi.Any{
 * 				WorkspaceId: "xx",
 * 			},
 * 			Type:               pulumi.String("MicrosoftMonitoringAgent"),
 * 			TypeHandlerVersion: pulumi.String("1.10"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.Extension;
 * import com.pulumi.azurenative.azurestackhci.ExtensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var extension = new Extension("extension", ExtensionArgs.builder()
 *             .arcSettingName("default")
 *             .clusterName("myCluster")
 *             .enableAutomaticUpgrade(false)
 *             .extensionName("MicrosoftMonitoringAgent")
 *             .protectedSettings(Map.of("workspaceKey", "xx"))
 *             .publisher("Microsoft.Compute")
 *             .resourceGroupName("test-rg")
 *             .settings(Map.of("workspaceId", "xx"))
 *             .type("MicrosoftMonitoringAgent")
 *             .typeHandlerVersion("1.10")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:Extension MicrosoftMonitoringAgent /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/arcSettings/{arcSettingName}/extensions/{extensionName}
 * ```
 * @property arcSettingName The name of the proxy resource holding details of HCI ArcSetting information.
 * @property autoUpgradeMinorVersion Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
 * @property clusterName The name of the cluster.
 * @property enableAutomaticUpgrade Indicates whether the extension should be automatically upgraded by the platform if there is a newer version available.
 * @property extensionName The name of the machine extension.
 * @property forceUpdateTag How the extension handler should be forced to update even if the extension configuration has not changed.
 * @property protectedSettings Protected settings (may contain secrets).
 * @property publisher The name of the extension handler publisher.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property settings Json formatted public settings for the extension.
 * @property type Specifies the type of the extension; an example is "CustomScriptExtension".
 * @property typeHandlerVersion Specifies the version of the script handler. Latest version would be used if not specified.
 */
public data class ExtensionArgs(
    public val arcSettingName: Output<String>? = null,
    public val autoUpgradeMinorVersion: Output<Boolean>? = null,
    public val clusterName: Output<String>? = null,
    public val enableAutomaticUpgrade: Output<Boolean>? = null,
    public val extensionName: Output<String>? = null,
    public val forceUpdateTag: Output<String>? = null,
    public val protectedSettings: Output<Any>? = null,
    public val publisher: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val settings: Output<Any>? = null,
    public val type: Output<String>? = null,
    public val typeHandlerVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.ExtensionArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.ExtensionArgs =
        com.pulumi.azurenative.azurestackhci.ExtensionArgs.builder()
            .arcSettingName(arcSettingName?.applyValue({ args0 -> args0 }))
            .autoUpgradeMinorVersion(autoUpgradeMinorVersion?.applyValue({ args0 -> args0 }))
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .enableAutomaticUpgrade(enableAutomaticUpgrade?.applyValue({ args0 -> args0 }))
            .extensionName(extensionName?.applyValue({ args0 -> args0 }))
            .forceUpdateTag(forceUpdateTag?.applyValue({ args0 -> args0 }))
            .protectedSettings(protectedSettings?.applyValue({ args0 -> args0 }))
            .publisher(publisher?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .settings(settings?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .typeHandlerVersion(typeHandlerVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExtensionArgs].
 */
@PulumiTagMarker
public class ExtensionArgsBuilder internal constructor() {
    private var arcSettingName: Output<String>? = null

    private var autoUpgradeMinorVersion: Output<Boolean>? = null

    private var clusterName: Output<String>? = null

    private var enableAutomaticUpgrade: Output<Boolean>? = null

    private var extensionName: Output<String>? = null

    private var forceUpdateTag: Output<String>? = null

    private var protectedSettings: Output<Any>? = null

    private var publisher: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var settings: Output<Any>? = null

    private var type: Output<String>? = null

    private var typeHandlerVersion: Output<String>? = null

    /**
     * @param value The name of the proxy resource holding details of HCI ArcSetting information.
     */
    @JvmName("amprklvccafruwgg")
    public suspend fun arcSettingName(`value`: Output<String>) {
        this.arcSettingName = value
    }

    /**
     * @param value Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
     */
    @JvmName("vcgyvbwesgwwbxto")
    public suspend fun autoUpgradeMinorVersion(`value`: Output<Boolean>) {
        this.autoUpgradeMinorVersion = value
    }

    /**
     * @param value The name of the cluster.
     */
    @JvmName("tgweffdrjaypogno")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Indicates whether the extension should be automatically upgraded by the platform if there is a newer version available.
     */
    @JvmName("dfnjuqnxbwvlmfao")
    public suspend fun enableAutomaticUpgrade(`value`: Output<Boolean>) {
        this.enableAutomaticUpgrade = value
    }

    /**
     * @param value The name of the machine extension.
     */
    @JvmName("sfgtbegmolwbmuci")
    public suspend fun extensionName(`value`: Output<String>) {
        this.extensionName = value
    }

    /**
     * @param value How the extension handler should be forced to update even if the extension configuration has not changed.
     */
    @JvmName("ygwkihcjvaeoemva")
    public suspend fun forceUpdateTag(`value`: Output<String>) {
        this.forceUpdateTag = value
    }

    /**
     * @param value Protected settings (may contain secrets).
     */
    @JvmName("elmjubqbnusokfsu")
    public suspend fun protectedSettings(`value`: Output<Any>) {
        this.protectedSettings = value
    }

    /**
     * @param value The name of the extension handler publisher.
     */
    @JvmName("rmcjcwlcgxxwfjje")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hqnsxgbhkehlvjvw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Json formatted public settings for the extension.
     */
    @JvmName("lgsawfgebpjnoqmg")
    public suspend fun settings(`value`: Output<Any>) {
        this.settings = value
    }

    /**
     * @param value Specifies the type of the extension; an example is "CustomScriptExtension".
     */
    @JvmName("xmwxhottepkbboaw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the version of the script handler. Latest version would be used if not specified.
     */
    @JvmName("xfxusalpwvffoulq")
    public suspend fun typeHandlerVersion(`value`: Output<String>) {
        this.typeHandlerVersion = value
    }

    /**
     * @param value The name of the proxy resource holding details of HCI ArcSetting information.
     */
    @JvmName("vuhgvjvsoeinuycl")
    public suspend fun arcSettingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arcSettingName = mapped
    }

    /**
     * @param value Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
     */
    @JvmName("cicdmtsflwyywlym")
    public suspend fun autoUpgradeMinorVersion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoUpgradeMinorVersion = mapped
    }

    /**
     * @param value The name of the cluster.
     */
    @JvmName("bcxvnwqmnhmsgmme")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Indicates whether the extension should be automatically upgraded by the platform if there is a newer version available.
     */
    @JvmName("udoigqdyeiwyiugy")
    public suspend fun enableAutomaticUpgrade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutomaticUpgrade = mapped
    }

    /**
     * @param value The name of the machine extension.
     */
    @JvmName("iindbwiydvmccfef")
    public suspend fun extensionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensionName = mapped
    }

    /**
     * @param value How the extension handler should be forced to update even if the extension configuration has not changed.
     */
    @JvmName("asdqqxfvlwagdhbw")
    public suspend fun forceUpdateTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceUpdateTag = mapped
    }

    /**
     * @param value Protected settings (may contain secrets).
     */
    @JvmName("uaoknjhbeythsigf")
    public suspend fun protectedSettings(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedSettings = mapped
    }

    /**
     * @param value The name of the extension handler publisher.
     */
    @JvmName("qfrsnxdnoumgdcbg")
    public suspend fun publisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wmveomrjynenlutp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Json formatted public settings for the extension.
     */
    @JvmName("buvvlvldkekgpuhj")
    public suspend fun settings(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param value Specifies the type of the extension; an example is "CustomScriptExtension".
     */
    @JvmName("acsktuboxuvswmum")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Specifies the version of the script handler. Latest version would be used if not specified.
     */
    @JvmName("kwkrbgdivywekjvl")
    public suspend fun typeHandlerVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.typeHandlerVersion = mapped
    }

    internal fun build(): ExtensionArgs = ExtensionArgs(
        arcSettingName = arcSettingName,
        autoUpgradeMinorVersion = autoUpgradeMinorVersion,
        clusterName = clusterName,
        enableAutomaticUpgrade = enableAutomaticUpgrade,
        extensionName = extensionName,
        forceUpdateTag = forceUpdateTag,
        protectedSettings = protectedSettings,
        publisher = publisher,
        resourceGroupName = resourceGroupName,
        settings = settings,
        type = type,
        typeHandlerVersion = typeHandlerVersion,
    )
}
