@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.MachineExtensionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes a Machine Extension.
 * Azure REST API version: 2022-12-15-preview.
 * ## Example Usage
 * ### Create or Update a Machine Extension (PUT)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machineExtension = new AzureNative.AzureStackHCI.MachineExtension("machineExtension", new()
 *     {
 *         ExtensionName = "CustomScriptExtension",
 *         Location = "eastus2euap",
 *         Name = "myMachine",
 *         Publisher = "Microsoft.Compute",
 *         ResourceGroupName = "myResourceGroup",
 *         Settings =
 *         {
 *             { "commandToExecute", "powershell.exe -c \"Get-Process | Where-Object { $_.CPU -gt 10000 }\"" },
 *         },
 *         Type = "CustomScriptExtension",
 *         TypeHandlerVersion = "1.10",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewMachineExtension(ctx, "machineExtension", &azurestackhci.MachineExtensionArgs{
 * 			ExtensionName:     pulumi.String("CustomScriptExtension"),
 * 			Location:          pulumi.String("eastus2euap"),
 * 			Name:              pulumi.String("myMachine"),
 * 			Publisher:         pulumi.String("Microsoft.Compute"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Settings: pulumi.Any{
 * 				CommandToExecute: "powershell.exe -c \"Get-Process | Where-Object { $_.CPU -gt 10000 }\"",
 * 			},
 * 			Type:               pulumi.String("CustomScriptExtension"),
 * 			TypeHandlerVersion: pulumi.String("1.10"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.MachineExtension;
 * import com.pulumi.azurenative.azurestackhci.MachineExtensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machineExtension = new MachineExtension("machineExtension", MachineExtensionArgs.builder()
 *             .extensionName("CustomScriptExtension")
 *             .location("eastus2euap")
 *             .name("myMachine")
 *             .publisher("Microsoft.Compute")
 *             .resourceGroupName("myResourceGroup")
 *             .settings(Map.of("commandToExecute", "powershell.exe -c \"Get-Process | Where-Object { $_.CPU -gt 10000 }\""))
 *             .type("CustomScriptExtension")
 *             .typeHandlerVersion("1.10")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:MachineExtension CustomScriptExtension /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/virtualMachines/{name}/extensions/{extensionName}
 * ```
 * @property autoUpgradeMinorVersion Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
 * @property extensionName The name of the machine extension.
 * @property forceUpdateTag How the extension handler should be forced to update even if the extension configuration has not changed.
 * @property location The location.
 * @property name The name of the machine where the extension should be created or updated.
 * @property protectedSettings The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
 * @property publisher The name of the extension handler publisher.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property settings Json formatted public settings for the extension.
 * @property tags The Resource tags.
 * @property type Specifies the type of the extension; an example is "CustomScriptExtension".
 * @property typeHandlerVersion Specifies the version of the script handler.
 */
public data class MachineExtensionArgs(
    public val autoUpgradeMinorVersion: Output<Boolean>? = null,
    public val extensionName: Output<String>? = null,
    public val forceUpdateTag: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val protectedSettings: Output<Any>? = null,
    public val publisher: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val settings: Output<Any>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
    public val typeHandlerVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.MachineExtensionArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.MachineExtensionArgs =
        com.pulumi.azurenative.azurestackhci.MachineExtensionArgs.builder()
            .autoUpgradeMinorVersion(autoUpgradeMinorVersion?.applyValue({ args0 -> args0 }))
            .extensionName(extensionName?.applyValue({ args0 -> args0 }))
            .forceUpdateTag(forceUpdateTag?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .protectedSettings(protectedSettings?.applyValue({ args0 -> args0 }))
            .publisher(publisher?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .settings(settings?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 }))
            .typeHandlerVersion(typeHandlerVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MachineExtensionArgs].
 */
@PulumiTagMarker
public class MachineExtensionArgsBuilder internal constructor() {
    private var autoUpgradeMinorVersion: Output<Boolean>? = null

    private var extensionName: Output<String>? = null

    private var forceUpdateTag: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var protectedSettings: Output<Any>? = null

    private var publisher: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var settings: Output<Any>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    private var typeHandlerVersion: Output<String>? = null

    /**
     * @param value Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
     */
    @JvmName("abxnxftvpbchibnr")
    public suspend fun autoUpgradeMinorVersion(`value`: Output<Boolean>) {
        this.autoUpgradeMinorVersion = value
    }

    /**
     * @param value The name of the machine extension.
     */
    @JvmName("romeydwcdtkfknod")
    public suspend fun extensionName(`value`: Output<String>) {
        this.extensionName = value
    }

    /**
     * @param value How the extension handler should be forced to update even if the extension configuration has not changed.
     */
    @JvmName("mfghfvjwkprhrpdu")
    public suspend fun forceUpdateTag(`value`: Output<String>) {
        this.forceUpdateTag = value
    }

    /**
     * @param value The location.
     */
    @JvmName("xmkqarvikpbjlxqx")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the machine where the extension should be created or updated.
     */
    @JvmName("ekjacroqbhgjcaie")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
     */
    @JvmName("kacklbfufmhkhhww")
    public suspend fun protectedSettings(`value`: Output<Any>) {
        this.protectedSettings = value
    }

    /**
     * @param value The name of the extension handler publisher.
     */
    @JvmName("gjvygenvqpfymaoe")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vuuyagayeybayjpc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Json formatted public settings for the extension.
     */
    @JvmName("ygfmcpxqactvbfga")
    public suspend fun settings(`value`: Output<Any>) {
        this.settings = value
    }

    /**
     * @param value The Resource tags.
     */
    @JvmName("pblqmvmeupyokath")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the type of the extension; an example is "CustomScriptExtension".
     */
    @JvmName("kyntmbghgmgncxlk")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the version of the script handler.
     */
    @JvmName("xyxvbublkedsgxpt")
    public suspend fun typeHandlerVersion(`value`: Output<String>) {
        this.typeHandlerVersion = value
    }

    /**
     * @param value Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
     */
    @JvmName("taslahtmbtaqktnh")
    public suspend fun autoUpgradeMinorVersion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoUpgradeMinorVersion = mapped
    }

    /**
     * @param value The name of the machine extension.
     */
    @JvmName("tgcrvgexnbcfqnqh")
    public suspend fun extensionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensionName = mapped
    }

    /**
     * @param value How the extension handler should be forced to update even if the extension configuration has not changed.
     */
    @JvmName("jqyjewccmqawqpmg")
    public suspend fun forceUpdateTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceUpdateTag = mapped
    }

    /**
     * @param value The location.
     */
    @JvmName("eodjvntoxowpebrs")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the machine where the extension should be created or updated.
     */
    @JvmName("snoygvdgxcowvlok")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
     */
    @JvmName("mujugvhmjrtpsaim")
    public suspend fun protectedSettings(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedSettings = mapped
    }

    /**
     * @param value The name of the extension handler publisher.
     */
    @JvmName("qybwybgaaxwuratc")
    public suspend fun publisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ujryfawfwhxdivlu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Json formatted public settings for the extension.
     */
    @JvmName("etseglvdfatjodbc")
    public suspend fun settings(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param value The Resource tags.
     */
    @JvmName("owjknaqboxjyylst")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The Resource tags.
     */
    @JvmName("cnyucoknwfiuahxb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies the type of the extension; an example is "CustomScriptExtension".
     */
    @JvmName("wqsgwdunbcrxdpkp")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Specifies the version of the script handler.
     */
    @JvmName("tsnomhvupwkfjelf")
    public suspend fun typeHandlerVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.typeHandlerVersion = mapped
    }

    internal fun build(): MachineExtensionArgs = MachineExtensionArgs(
        autoUpgradeMinorVersion = autoUpgradeMinorVersion,
        extensionName = extensionName,
        forceUpdateTag = forceUpdateTag,
        location = location,
        name = name,
        protectedSettings = protectedSettings,
        publisher = publisher,
        resourceGroupName = resourceGroupName,
        settings = settings,
        tags = tags,
        type = type,
        typeHandlerVersion = typeHandlerVersion,
    )
}
