@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.IPConfigurationResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.InterfaceDNSSettingsResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.NetworkInterfaceStatusResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.IPConfigurationResponse.Companion.toKotlin as iPConfigurationResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.InterfaceDNSSettingsResponse.Companion.toKotlin as interfaceDNSSettingsResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.NetworkInterfaceStatusResponse.Companion.toKotlin as networkInterfaceStatusResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [NetworkInterface].
 */
@PulumiTagMarker
public class NetworkInterfaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkInterfaceArgs = NetworkInterfaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkInterfaceArgsBuilder.() -> Unit) {
        val builder = NetworkInterfaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NetworkInterface {
        val builtJavaResource =
            com.pulumi.azurenative.azurestackhci.NetworkInterface(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NetworkInterface(builtJavaResource)
    }
}

/**
 * The network interface resource definition.
 * Azure REST API version: 2022-12-15-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview.
 * ## Example Usage
 * ### PutNetworkInterface
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkInterface = new AzureNative.AzureStackHCI.NetworkInterface("networkInterface", new()
 *     {
 *         ExtendedLocation = new AzureNative.AzureStackHCI.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location",
 *             Type = "CustomLocation",
 *         },
 *         IpConfigurations = new[]
 *         {
 *             new AzureNative.AzureStackHCI.Inputs.IPConfigurationArgs
 *             {
 *                 Name = "ipconfig-sample",
 *                 Properties = new AzureNative.AzureStackHCI.Inputs.IPConfigurationPropertiesArgs
 *                 {
 *                     Subnet = new AzureNative.AzureStackHCI.Inputs.IPConfigurationSubnetArgs
 *                     {
 *                         Id = "test-vnet",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "West US2",
 *         NetworkInterfaceName = "test-nic",
 *         ResourceGroupName = "test-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewNetworkInterface(ctx, "networkInterface", &azurestackhci.NetworkInterfaceArgs{
 * 			ExtendedLocation: &azurestackhci.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			IpConfigurations: []azurestackhci.IPConfigurationArgs{
 * 				{
 * 					Name: pulumi.String("ipconfig-sample"),
 * 					Properties: {
 * 						Subnet: {
 * 							Id: pulumi.String("test-vnet"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location:             pulumi.String("West US2"),
 * 			NetworkInterfaceName: pulumi.String("test-nic"),
 * 			ResourceGroupName:    pulumi.String("test-rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.NetworkInterface;
 * import com.pulumi.azurenative.azurestackhci.NetworkInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkInterface = new NetworkInterface("networkInterface", NetworkInterfaceArgs.builder()
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .ipConfigurations(Map.ofEntries(
 *                 Map.entry("name", "ipconfig-sample"),
 *                 Map.entry("properties", Map.of("subnet", Map.of("id", "test-vnet")))
 *             ))
 *             .location("West US2")
 *             .networkInterfaceName("test-nic")
 *             .resourceGroupName("test-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:NetworkInterface test-nic /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/networkInterfaces/{networkInterfaceName}
 * ```
 */
public class NetworkInterface internal constructor(
    override val javaResource: com.pulumi.azurenative.azurestackhci.NetworkInterface,
) : KotlinCustomResource(javaResource, NetworkInterfaceMapper) {
    /**
     * DNS Settings for the interface
     */
    public val dnsSettings: Output<InterfaceDNSSettingsResponse>?
        get() = javaResource.dnsSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    interfaceDNSSettingsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The extendedLocation of the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * IPConfigurations - A list of IPConfigurations of the network interface.
     */
    public val ipConfigurations: Output<List<IPConfigurationResponse>>?
        get() = javaResource.ipConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        iPConfigurationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * MacAddress - The MAC address of the network interface.
     */
    public val macAddress: Output<String>?
        get() = javaResource.macAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the network interface.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The observed state of network interfaces
     */
    public val status: Output<NetworkInterfaceStatusResponse>
        get() = javaResource.status().applyValue({ args0 ->
            args0.let({ args0 ->
                networkInterfaceStatusResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NetworkInterfaceMapper : ResourceMapper<NetworkInterface> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azurestackhci.NetworkInterface::class == javaResource::class

    override fun map(javaResource: Resource): NetworkInterface = NetworkInterface(
        javaResource as
            com.pulumi.azurenative.azurestackhci.NetworkInterface,
    )
}

/**
 * @see [NetworkInterface].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkInterface].
 */
public suspend fun networkInterface(
    name: String,
    block: suspend NetworkInterfaceResourceBuilder.() -> Unit,
): NetworkInterface {
    val builder = NetworkInterfaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkInterface].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkInterface(name: String): NetworkInterface {
    val builder = NetworkInterfaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
