@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SecurityComplianceStatusResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SecurityComplianceStatusResponse.Companion.toKotlin as securityComplianceStatusResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [SecuritySetting].
 */
@PulumiTagMarker
public class SecuritySettingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecuritySettingArgs = SecuritySettingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecuritySettingArgsBuilder.() -> Unit) {
        val builder = SecuritySettingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SecuritySetting {
        val builtJavaResource =
            com.pulumi.azurenative.azurestackhci.SecuritySetting(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SecuritySetting(builtJavaResource)
    }
}

/**
 * Security settings proxy resource
 * Azure REST API version: 2023-11-01-preview.
 * ## Example Usage
 * ### Create Security Settings
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var securitySetting = new AzureNative.AzureStackHCI.SecuritySetting("securitySetting", new()
 *     {
 *         ClusterName = "myCluster",
 *         ResourceGroupName = "test-rg",
 *         SecuredCoreComplianceAssignment = "Audit",
 *         SecuritySettingsName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewSecuritySetting(ctx, "securitySetting", &azurestackhci.SecuritySettingArgs{
 * 			ClusterName:                     pulumi.String("myCluster"),
 * 			ResourceGroupName:               pulumi.String("test-rg"),
 * 			SecuredCoreComplianceAssignment: pulumi.String("Audit"),
 * 			SecuritySettingsName:            pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.SecuritySetting;
 * import com.pulumi.azurenative.azurestackhci.SecuritySettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var securitySetting = new SecuritySetting("securitySetting", SecuritySettingArgs.builder()
 *             .clusterName("myCluster")
 *             .resourceGroupName("test-rg")
 *             .securedCoreComplianceAssignment("Audit")
 *             .securitySettingsName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:SecuritySetting myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/securitySettings/{securitySettingsName}
 * ```
 */
public class SecuritySetting internal constructor(
    override val javaResource: com.pulumi.azurenative.azurestackhci.SecuritySetting,
) : KotlinCustomResource(javaResource, SecuritySettingMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Secured Core Compliance Assignment
     */
    public val securedCoreComplianceAssignment: Output<String>?
        get() = javaResource.securedCoreComplianceAssignment().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Security Compliance Status
     */
    public val securityComplianceStatus: Output<SecurityComplianceStatusResponse>
        get() = javaResource.securityComplianceStatus().applyValue({ args0 ->
            args0.let({ args0 ->
                securityComplianceStatusResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SecuritySettingMapper : ResourceMapper<SecuritySetting> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azurestackhci.SecuritySetting::class == javaResource::class

    override fun map(javaResource: Resource): SecuritySetting = SecuritySetting(
        javaResource as
            com.pulumi.azurenative.azurestackhci.SecuritySetting,
    )
}

/**
 * @see [SecuritySetting].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecuritySetting].
 */
public suspend fun securitySetting(
    name: String,
    block: suspend SecuritySettingResourceBuilder.() -> Unit,
): SecuritySetting {
    val builder = SecuritySettingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecuritySetting].
 * @param name The _unique_ name of the resulting resource.
 */
public fun securitySetting(name: String): SecuritySetting {
    val builder = SecuritySettingResourceBuilder()
    builder.name(name)
    return builder.build()
}
