@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.StorageContainerArgs.builder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The storage container resource definition.
 * Azure REST API version: 2022-12-15-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview.
 * ## Example Usage
 * ### PutStorageContainer
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageContainer = new AzureNative.AzureStackHCI.StorageContainer("storageContainer", new()
 *     {
 *         ExtendedLocation = new AzureNative.AzureStackHCI.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location",
 *             Type = "CustomLocation",
 *         },
 *         Location = "West US2",
 *         Path = "C:\\container_storage",
 *         ResourceGroupName = "test-rg",
 *         StorageContainerName = "Default_Container",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewStorageContainer(ctx, "storageContainer", &azurestackhci.StorageContainerArgs{
 * 			ExtendedLocation: &azurestackhci.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location:             pulumi.String("West US2"),
 * 			Path:                 pulumi.String("C:\\container_storage"),
 * 			ResourceGroupName:    pulumi.String("test-rg"),
 * 			StorageContainerName: pulumi.String("Default_Container"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.StorageContainer;
 * import com.pulumi.azurenative.azurestackhci.StorageContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageContainer = new StorageContainer("storageContainer", StorageContainerArgs.builder()
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .location("West US2")
 *             .path("C:\\container_storage")
 *             .resourceGroupName("test-rg")
 *             .storageContainerName("Default_Container")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:StorageContainer Default_Container /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/storageContainers/{storageContainerName}
 * ```
 * @property extendedLocation The extendedLocation of the resource.
 * @property location The geo-location where the resource lives
 * @property path Path of the storage container on the disk
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageContainerName Name of the storage container
 * @property tags Resource tags.
 */
public data class StorageContainerArgs(
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val location: Output<String>? = null,
    public val path: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storageContainerName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.StorageContainerArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.StorageContainerArgs =
        com.pulumi.azurenative.azurestackhci.StorageContainerArgs.builder()
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageContainerName(storageContainerName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [StorageContainerArgs].
 */
@PulumiTagMarker
public class StorageContainerArgsBuilder internal constructor() {
    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var location: Output<String>? = null

    private var path: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var storageContainerName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The extendedLocation of the resource.
     */
    @JvmName("ifdsquvqfreuwcid")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("xdpysyfrulokwugm")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Path of the storage container on the disk
     */
    @JvmName("bhblyaeqwocqcicc")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("idjopjldwyhfbhgv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the storage container
     */
    @JvmName("gmcicwukqdthflky")
    public suspend fun storageContainerName(`value`: Output<String>) {
        this.storageContainerName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rochtxxxjagcljwa")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The extendedLocation of the resource.
     */
    @JvmName("dabotalumngansyk")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extendedLocation of the resource.
     */
    @JvmName("vpecegecwktrpikb")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ueyinctwrvuvtqca")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Path of the storage container on the disk
     */
    @JvmName("nacftmtymfollomd")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jwmjtjidebwnuifi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the storage container
     */
    @JvmName("ovxnbpwijhdceaom")
    public suspend fun storageContainerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageContainerName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("slefvuhyiwnoxrwn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("vtcngyftaybkxesk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): StorageContainerArgs = StorageContainerArgs(
        extendedLocation = extendedLocation,
        location = location,
        path = path,
        resourceGroupName = resourceGroupName,
        storageContainerName = storageContainerName,
        tags = tags,
    )
}
