@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.UpdateRunArgs.builder
import com.pulumi.azurenative.azurestackhci.kotlin.enums.UpdateRunPropertiesState
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.StepArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.StepArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Details of an Update run
 * Azure REST API version: 2023-03-01.
 * Other available API versions: 2022-12-15-preview, 2023-06-01, 2023-08-01, 2023-08-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### Get Update runs under cluster resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var updateRun = new AzureNative.AzureStackHCI.UpdateRun("updateRun", new()
 *     {
 *         ClusterName = "testcluster",
 *         Description = "Update Azure Stack.",
 *         EndTimeUtc = "2022-04-06T13:58:42.969006+00:00",
 *         ErrorMessage = "",
 *         LastUpdatedTimeUtc = "2022-04-06T13:58:42.969006+00:00",
 *         Name = "Unnamed step",
 *         ResourceGroupName = "testrg",
 *         StartTimeUtc = "2022-04-06T01:36:33.3876751+00:00",
 *         Status = "Success",
 *         Steps = new[]
 *         {
 *             new AzureNative.AzureStackHCI.Inputs.StepArgs
 *             {
 *                 Description = "Prepare for SSU update",
 *                 EndTimeUtc = "2022-04-06T01:37:16.8728314+00:00",
 *                 ErrorMessage = "",
 *                 LastUpdatedTimeUtc = "2022-04-06T01:37:16.8728314+00:00",
 *                 Name = "PreUpdate Cloud",
 *                 StartTimeUtc = "2022-04-06T01:36:33.3876751+00:00",
 *                 Status = "Success",
 *                 Steps = new[] {},
 *             },
 *         },
 *         UpdateName = "Microsoft4.2203.2.32",
 *         UpdateRunName = "23b779ba-0d52-4a80-8571-45ca74664ec3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewUpdateRun(ctx, "updateRun", &azurestackhci.UpdateRunArgs{
 * 			ClusterName:        pulumi.String("testcluster"),
 * 			Description:        pulumi.String("Update Azure Stack."),
 * 			EndTimeUtc:         pulumi.String("2022-04-06T13:58:42.969006+00:00"),
 * 			ErrorMessage:       pulumi.String(""),
 * 			LastUpdatedTimeUtc: pulumi.String("2022-04-06T13:58:42.969006+00:00"),
 * 			Name:               pulumi.String("Unnamed step"),
 * 			ResourceGroupName:  pulumi.String("testrg"),
 * 			StartTimeUtc:       pulumi.String("2022-04-06T01:36:33.3876751+00:00"),
 * 			Status:             pulumi.String("Success"),
 * 			Steps: []azurestackhci.StepArgs{
 * 				{
 * 					Description:        pulumi.String("Prepare for SSU update"),
 * 					EndTimeUtc:         pulumi.String("2022-04-06T01:37:16.8728314+00:00"),
 * 					ErrorMessage:       pulumi.String(""),
 * 					LastUpdatedTimeUtc: pulumi.String("2022-04-06T01:37:16.8728314+00:00"),
 * 					Name:               pulumi.String("PreUpdate Cloud"),
 * 					StartTimeUtc:       pulumi.String("2022-04-06T01:36:33.3876751+00:00"),
 * 					Status:             pulumi.String("Success"),
 * 					Steps:              azurestackhci.StepArray{},
 * 				},
 * 			},
 * 			UpdateName:    pulumi.String("Microsoft4.2203.2.32"),
 * 			UpdateRunName: pulumi.String("23b779ba-0d52-4a80-8571-45ca74664ec3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.UpdateRun;
 * import com.pulumi.azurenative.azurestackhci.UpdateRunArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var updateRun = new UpdateRun("updateRun", UpdateRunArgs.builder()
 *             .clusterName("testcluster")
 *             .description("Update Azure Stack.")
 *             .endTimeUtc("2022-04-06T13:58:42.969006+00:00")
 *             .errorMessage("")
 *             .lastUpdatedTimeUtc("2022-04-06T13:58:42.969006+00:00")
 *             .name("Unnamed step")
 *             .resourceGroupName("testrg")
 *             .startTimeUtc("2022-04-06T01:36:33.3876751+00:00")
 *             .status("Success")
 *             .steps(Map.ofEntries(
 *                 Map.entry("description", "Prepare for SSU update"),
 *                 Map.entry("endTimeUtc", "2022-04-06T01:37:16.8728314+00:00"),
 *                 Map.entry("errorMessage", ""),
 *                 Map.entry("lastUpdatedTimeUtc", "2022-04-06T01:37:16.8728314+00:00"),
 *                 Map.entry("name", "PreUpdate Cloud"),
 *                 Map.entry("startTimeUtc", "2022-04-06T01:36:33.3876751+00:00"),
 *                 Map.entry("status", "Success"),
 *                 Map.entry("steps", )
 *             ))
 *             .updateName("Microsoft4.2203.2.32")
 *             .updateRunName("23b779ba-0d52-4a80-8571-45ca74664ec3")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:UpdateRun Microsoft4.2203.2.32/23b779ba-0d52-4a80-8571-45ca74664ec3 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/updates/{updateName}/updateRuns/{updateRunName}
 * ```
 * @property clusterName The name of the cluster.
 * @property description More detailed description of the step.
 * @property duration Duration of the update run.
 * @property endTimeUtc When the step reached a terminal state.
 * @property errorMessage Error message, specified if the step is in a failed state.
 * @property lastUpdatedTime Timestamp of the most recently completed step in the update run.
 * @property lastUpdatedTimeUtc Completion time of this step or the last completed sub-step.
 * @property location The geo-location where the resource lives
 * @property name Name of the step.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property startTimeUtc When the step started, or empty if it has not started executing.
 * @property state State of the update run.
 * @property status Status of the step, bubbled up from the ECE action plan for installation attempts. Values are: 'Success', 'Error', 'InProgress', and 'Unknown status'.
 * @property steps Recursive model for child steps of this step.
 * @property timeStarted Timestamp of the update run was started.
 * @property updateName The name of the Update
 * @property updateRunName The name of the Update Run
 */
public data class UpdateRunArgs(
    public val clusterName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val duration: Output<String>? = null,
    public val endTimeUtc: Output<String>? = null,
    public val errorMessage: Output<String>? = null,
    public val lastUpdatedTime: Output<String>? = null,
    public val lastUpdatedTimeUtc: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val startTimeUtc: Output<String>? = null,
    public val state: Output<Either<String, UpdateRunPropertiesState>>? = null,
    public val status: Output<String>? = null,
    public val steps: Output<List<StepArgs>>? = null,
    public val timeStarted: Output<String>? = null,
    public val updateName: Output<String>? = null,
    public val updateRunName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.UpdateRunArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.UpdateRunArgs =
        com.pulumi.azurenative.azurestackhci.UpdateRunArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .duration(duration?.applyValue({ args0 -> args0 }))
            .endTimeUtc(endTimeUtc?.applyValue({ args0 -> args0 }))
            .errorMessage(errorMessage?.applyValue({ args0 -> args0 }))
            .lastUpdatedTime(lastUpdatedTime?.applyValue({ args0 -> args0 }))
            .lastUpdatedTimeUtc(lastUpdatedTimeUtc?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .startTimeUtc(startTimeUtc?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .status(status?.applyValue({ args0 -> args0 }))
            .steps(steps?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .timeStarted(timeStarted?.applyValue({ args0 -> args0 }))
            .updateName(updateName?.applyValue({ args0 -> args0 }))
            .updateRunName(updateRunName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UpdateRunArgs].
 */
@PulumiTagMarker
public class UpdateRunArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var description: Output<String>? = null

    private var duration: Output<String>? = null

    private var endTimeUtc: Output<String>? = null

    private var errorMessage: Output<String>? = null

    private var lastUpdatedTime: Output<String>? = null

    private var lastUpdatedTimeUtc: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var startTimeUtc: Output<String>? = null

    private var state: Output<Either<String, UpdateRunPropertiesState>>? = null

    private var status: Output<String>? = null

    private var steps: Output<List<StepArgs>>? = null

    private var timeStarted: Output<String>? = null

    private var updateName: Output<String>? = null

    private var updateRunName: Output<String>? = null

    /**
     * @param value The name of the cluster.
     */
    @JvmName("xoahcuxniwhrcwrs")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value More detailed description of the step.
     */
    @JvmName("ouhdhdmqqnwcjunv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Duration of the update run.
     */
    @JvmName("bkhcvplljatwuqga")
    public suspend fun duration(`value`: Output<String>) {
        this.duration = value
    }

    /**
     * @param value When the step reached a terminal state.
     */
    @JvmName("yqubectpihdlkdhx")
    public suspend fun endTimeUtc(`value`: Output<String>) {
        this.endTimeUtc = value
    }

    /**
     * @param value Error message, specified if the step is in a failed state.
     */
    @JvmName("vifygjwhafubcprt")
    public suspend fun errorMessage(`value`: Output<String>) {
        this.errorMessage = value
    }

    /**
     * @param value Timestamp of the most recently completed step in the update run.
     */
    @JvmName("uhvsnvqlnbjuxubc")
    public suspend fun lastUpdatedTime(`value`: Output<String>) {
        this.lastUpdatedTime = value
    }

    /**
     * @param value Completion time of this step or the last completed sub-step.
     */
    @JvmName("oonksdacsuiovfmw")
    public suspend fun lastUpdatedTimeUtc(`value`: Output<String>) {
        this.lastUpdatedTimeUtc = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("nankwdycutoqitei")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the step.
     */
    @JvmName("uektjtbyrbgixkew")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kqsxsxrcrggbbbaa")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value When the step started, or empty if it has not started executing.
     */
    @JvmName("agalyuxahkjgbkkw")
    public suspend fun startTimeUtc(`value`: Output<String>) {
        this.startTimeUtc = value
    }

    /**
     * @param value State of the update run.
     */
    @JvmName("yvexreqymslyuhim")
    public suspend fun state(`value`: Output<Either<String, UpdateRunPropertiesState>>) {
        this.state = value
    }

    /**
     * @param value Status of the step, bubbled up from the ECE action plan for installation attempts. Values are: 'Success', 'Error', 'InProgress', and 'Unknown status'.
     */
    @JvmName("shtqxyrcgrhmtnhf")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Recursive model for child steps of this step.
     */
    @JvmName("jpgajhdammyrmfql")
    public suspend fun steps(`value`: Output<List<StepArgs>>) {
        this.steps = value
    }

    @JvmName("dgdivtkqdyoboayw")
    public suspend fun steps(vararg values: Output<StepArgs>) {
        this.steps = Output.all(values.asList())
    }

    /**
     * @param values Recursive model for child steps of this step.
     */
    @JvmName("fxlauamiyhwbsayl")
    public suspend fun steps(values: List<Output<StepArgs>>) {
        this.steps = Output.all(values)
    }

    /**
     * @param value Timestamp of the update run was started.
     */
    @JvmName("uavpkhsiwrkahuhe")
    public suspend fun timeStarted(`value`: Output<String>) {
        this.timeStarted = value
    }

    /**
     * @param value The name of the Update
     */
    @JvmName("ebaefioylaslnrdk")
    public suspend fun updateName(`value`: Output<String>) {
        this.updateName = value
    }

    /**
     * @param value The name of the Update Run
     */
    @JvmName("wwqoshymfhrkyqtc")
    public suspend fun updateRunName(`value`: Output<String>) {
        this.updateRunName = value
    }

    /**
     * @param value The name of the cluster.
     */
    @JvmName("mbifutvrbuemmdqf")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value More detailed description of the step.
     */
    @JvmName("wlawodykjdcykpko")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Duration of the update run.
     */
    @JvmName("nenmxsiniwxqwsig")
    public suspend fun duration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value When the step reached a terminal state.
     */
    @JvmName("jgktjrghbudjrjvs")
    public suspend fun endTimeUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTimeUtc = mapped
    }

    /**
     * @param value Error message, specified if the step is in a failed state.
     */
    @JvmName("pyfrxpmrkpveolbj")
    public suspend fun errorMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorMessage = mapped
    }

    /**
     * @param value Timestamp of the most recently completed step in the update run.
     */
    @JvmName("wfqptovrdmfajbvk")
    public suspend fun lastUpdatedTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastUpdatedTime = mapped
    }

    /**
     * @param value Completion time of this step or the last completed sub-step.
     */
    @JvmName("pxbllmorvnlmgrtp")
    public suspend fun lastUpdatedTimeUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastUpdatedTimeUtc = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("dubjekeykjadgirk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the step.
     */
    @JvmName("gldlfpnodqdiacrq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qrengdhuhujtaepo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value When the step started, or empty if it has not started executing.
     */
    @JvmName("bisitjtdmfqtujxu")
    public suspend fun startTimeUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTimeUtc = mapped
    }

    /**
     * @param value State of the update run.
     */
    @JvmName("cbfigbkianhevhdn")
    public suspend fun state(`value`: Either<String, UpdateRunPropertiesState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value State of the update run.
     */
    @JvmName("vhrskwypvhpcpkqn")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, UpdateRunPropertiesState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value State of the update run.
     */
    @JvmName("isuyvgbafrclomyt")
    public fun state(`value`: UpdateRunPropertiesState) {
        val toBeMapped = Either.ofRight<String, UpdateRunPropertiesState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Status of the step, bubbled up from the ECE action plan for installation attempts. Values are: 'Success', 'Error', 'InProgress', and 'Unknown status'.
     */
    @JvmName("tjdpdlrjnwgutsty")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Recursive model for child steps of this step.
     */
    @JvmName("vbiridijbcpsfyxd")
    public suspend fun steps(`value`: List<StepArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.steps = mapped
    }

    /**
     * @param argument Recursive model for child steps of this step.
     */
    @JvmName("iqftxgmwflnclqwm")
    public suspend fun steps(argument: List<suspend StepArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { StepArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.steps = mapped
    }

    /**
     * @param argument Recursive model for child steps of this step.
     */
    @JvmName("kbjtwissdbavvgbe")
    public suspend fun steps(vararg argument: suspend StepArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { StepArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.steps = mapped
    }

    /**
     * @param argument Recursive model for child steps of this step.
     */
    @JvmName("nsdfjkdsxgewpjcr")
    public suspend fun steps(argument: suspend StepArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StepArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.steps = mapped
    }

    /**
     * @param values Recursive model for child steps of this step.
     */
    @JvmName("ssyquxpqfrrnmtpw")
    public suspend fun steps(vararg values: StepArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.steps = mapped
    }

    /**
     * @param value Timestamp of the update run was started.
     */
    @JvmName("xcqvgopgvwmrpjkb")
    public suspend fun timeStarted(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeStarted = mapped
    }

    /**
     * @param value The name of the Update
     */
    @JvmName("cpsduwishyilkvoo")
    public suspend fun updateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updateName = mapped
    }

    /**
     * @param value The name of the Update Run
     */
    @JvmName("rlfuxrepmjhiknla")
    public suspend fun updateRunName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updateRunName = mapped
    }

    internal fun build(): UpdateRunArgs = UpdateRunArgs(
        clusterName = clusterName,
        description = description,
        duration = duration,
        endTimeUtc = endTimeUtc,
        errorMessage = errorMessage,
        lastUpdatedTime = lastUpdatedTime,
        lastUpdatedTimeUtc = lastUpdatedTimeUtc,
        location = location,
        name = name,
        resourceGroupName = resourceGroupName,
        startTimeUtc = startTimeUtc,
        state = state,
        status = status,
        steps = steps,
        timeStarted = timeStarted,
        updateName = updateName,
        updateRunName = updateRunName,
    )
}
