@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.VirtualMachineArgs.builder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.VirtualMachinePropertiesHardwareProfileArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.VirtualMachinePropertiesHardwareProfileArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.VirtualMachinePropertiesNetworkProfileArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.VirtualMachinePropertiesNetworkProfileArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.VirtualMachinePropertiesOsProfileArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.VirtualMachinePropertiesOsProfileArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.VirtualMachinePropertiesSecurityProfileArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.VirtualMachinePropertiesSecurityProfileArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.VirtualMachinePropertiesStorageProfileArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.VirtualMachinePropertiesStorageProfileArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The virtual machine resource definition.
 * Azure REST API version: 2022-12-15-preview.
 * ## Example Usage
 * ### PutVirtualMachineWithGalleryImage
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.AzureStackHCI.VirtualMachine("virtualMachine", new()
 *     {
 *         ExtendedLocation = new AzureNative.AzureStackHCI.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location",
 *             Type = "CustomLocation",
 *         },
 *         HardwareProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesHardwareProfileArgs
 *         {
 *             VmSize = "Default",
 *         },
 *         Location = "West US2",
 *         NetworkProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesNetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesNetworkInterfacesArgs
 *                 {
 *                     Id = "test-nic",
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesOsProfileArgs
 *         {
 *             AdminPassword = "password",
 *             AdminUsername = "localadmin",
 *             ComputerName = "luamaster",
 *         },
 *         ResourceGroupName = "test-rg",
 *         SecurityProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesSecurityProfileArgs
 *         {
 *             EnableTPM = true,
 *             UefiSettings = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesUefiSettingsArgs
 *             {
 *                 SecureBootEnabled = true,
 *             },
 *         },
 *         StorageProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesStorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesImageReferenceArgs
 *             {
 *                 Id = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/galleryImages/test-gallery-image",
 *             },
 *             VmConfigStoragePathId = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container",
 *         },
 *         VirtualMachineName = "test-vm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewVirtualMachine(ctx, "virtualMachine", &azurestackhci.VirtualMachineArgs{
 * 			ExtendedLocation: &azurestackhci.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			HardwareProfile: &azurestackhci.VirtualMachinePropertiesHardwareProfileArgs{
 * 				VmSize: pulumi.String("Default"),
 * 			},
 * 			Location: pulumi.String("West US2"),
 * 			NetworkProfile: azurestackhci.VirtualMachinePropertiesResponseNetworkProfile{
 * 				NetworkInterfaces: azurestackhci.VirtualMachinePropertiesNetworkInterfacesArray{
 * 					&azurestackhci.VirtualMachinePropertiesNetworkInterfacesArgs{
 * 						Id: pulumi.String("test-nic"),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &azurestackhci.VirtualMachinePropertiesOsProfileArgs{
 * 				AdminPassword: pulumi.String("password"),
 * 				AdminUsername: pulumi.String("localadmin"),
 * 				ComputerName:  pulumi.String("luamaster"),
 * 			},
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			SecurityProfile: azurestackhci.VirtualMachinePropertiesResponseSecurityProfile{
 * 				EnableTPM: pulumi.Bool(true),
 * 				UefiSettings: &azurestackhci.VirtualMachinePropertiesUefiSettingsArgs{
 * 					SecureBootEnabled: pulumi.Bool(true),
 * 				},
 * 			},
 * 			StorageProfile: azurestackhci.VirtualMachinePropertiesResponseStorageProfile{
 * 				ImageReference: &azurestackhci.VirtualMachinePropertiesImageReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/galleryImages/test-gallery-image"),
 * 				},
 * 				VmConfigStoragePathId: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container"),
 * 			},
 * 			VirtualMachineName: pulumi.String("test-vm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.VirtualMachine;
 * import com.pulumi.azurenative.azurestackhci.VirtualMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .hardwareProfile(Map.of("vmSize", "Default"))
 *             .location("West US2")
 *             .networkProfile(Map.of("networkInterfaces", Map.of("id", "test-nic")))
 *             .osProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "password"),
 *                 Map.entry("adminUsername", "localadmin"),
 *                 Map.entry("computerName", "luamaster")
 *             ))
 *             .resourceGroupName("test-rg")
 *             .securityProfile(Map.ofEntries(
 *                 Map.entry("enableTPM", true),
 *                 Map.entry("uefiSettings", Map.of("secureBootEnabled", true))
 *             ))
 *             .storageProfile(Map.ofEntries(
 *                 Map.entry("imageReference", Map.of("id", "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/galleryImages/test-gallery-image")),
 *                 Map.entry("vmConfigStoragePathId", "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container")
 *             ))
 *             .virtualMachineName("test-vm")
 *             .build());
 *     }
 * }
 * ```
 * ### PutVirtualMachineWithMarketplaceGalleryImage
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.AzureStackHCI.VirtualMachine("virtualMachine", new()
 *     {
 *         ExtendedLocation = new AzureNative.AzureStackHCI.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location",
 *             Type = "CustomLocation",
 *         },
 *         HardwareProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesHardwareProfileArgs
 *         {
 *             VmSize = "Default",
 *         },
 *         Location = "West US2",
 *         NetworkProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesNetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesNetworkInterfacesArgs
 *                 {
 *                     Id = "test-nic",
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesOsProfileArgs
 *         {
 *             AdminPassword = "password",
 *             AdminUsername = "localadmin",
 *             ComputerName = "luamaster",
 *         },
 *         ResourceGroupName = "test-rg",
 *         SecurityProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesSecurityProfileArgs
 *         {
 *             EnableTPM = true,
 *             UefiSettings = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesUefiSettingsArgs
 *             {
 *                 SecureBootEnabled = true,
 *             },
 *         },
 *         StorageProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesStorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesImageReferenceArgs
 *             {
 *                 Id = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/marketplaceGalleryImages/test-marketplace-gallery-image",
 *             },
 *             VmConfigStoragePathId = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container",
 *         },
 *         VirtualMachineName = "test-vm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewVirtualMachine(ctx, "virtualMachine", &azurestackhci.VirtualMachineArgs{
 * 			ExtendedLocation: &azurestackhci.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			HardwareProfile: &azurestackhci.VirtualMachinePropertiesHardwareProfileArgs{
 * 				VmSize: pulumi.String("Default"),
 * 			},
 * 			Location: pulumi.String("West US2"),
 * 			NetworkProfile: azurestackhci.VirtualMachinePropertiesResponseNetworkProfile{
 * 				NetworkInterfaces: azurestackhci.VirtualMachinePropertiesNetworkInterfacesArray{
 * 					&azurestackhci.VirtualMachinePropertiesNetworkInterfacesArgs{
 * 						Id: pulumi.String("test-nic"),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &azurestackhci.VirtualMachinePropertiesOsProfileArgs{
 * 				AdminPassword: pulumi.String("password"),
 * 				AdminUsername: pulumi.String("localadmin"),
 * 				ComputerName:  pulumi.String("luamaster"),
 * 			},
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			SecurityProfile: azurestackhci.VirtualMachinePropertiesResponseSecurityProfile{
 * 				EnableTPM: pulumi.Bool(true),
 * 				UefiSettings: &azurestackhci.VirtualMachinePropertiesUefiSettingsArgs{
 * 					SecureBootEnabled: pulumi.Bool(true),
 * 				},
 * 			},
 * 			StorageProfile: azurestackhci.VirtualMachinePropertiesResponseStorageProfile{
 * 				ImageReference: &azurestackhci.VirtualMachinePropertiesImageReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/marketplaceGalleryImages/test-marketplace-gallery-image"),
 * 				},
 * 				VmConfigStoragePathId: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container"),
 * 			},
 * 			VirtualMachineName: pulumi.String("test-vm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.VirtualMachine;
 * import com.pulumi.azurenative.azurestackhci.VirtualMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .hardwareProfile(Map.of("vmSize", "Default"))
 *             .location("West US2")
 *             .networkProfile(Map.of("networkInterfaces", Map.of("id", "test-nic")))
 *             .osProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "password"),
 *                 Map.entry("adminUsername", "localadmin"),
 *                 Map.entry("computerName", "luamaster")
 *             ))
 *             .resourceGroupName("test-rg")
 *             .securityProfile(Map.ofEntries(
 *                 Map.entry("enableTPM", true),
 *                 Map.entry("uefiSettings", Map.of("secureBootEnabled", true))
 *             ))
 *             .storageProfile(Map.ofEntries(
 *                 Map.entry("imageReference", Map.of("id", "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/marketplaceGalleryImages/test-marketplace-gallery-image")),
 *                 Map.entry("vmConfigStoragePathId", "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container")
 *             ))
 *             .virtualMachineName("test-vm")
 *             .build());
 *     }
 * }
 * ```
 * ### PutVirtualMachineWithOsDisk
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.AzureStackHCI.VirtualMachine("virtualMachine", new()
 *     {
 *         ExtendedLocation = new AzureNative.AzureStackHCI.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location",
 *             Type = "CustomLocation",
 *         },
 *         HardwareProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesHardwareProfileArgs
 *         {
 *             VmSize = "Default",
 *         },
 *         Location = "West US2",
 *         NetworkProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesNetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesNetworkInterfacesArgs
 *                 {
 *                     Id = "test-nic",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "test-rg",
 *         SecurityProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesSecurityProfileArgs
 *         {
 *             EnableTPM = true,
 *             UefiSettings = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesUefiSettingsArgs
 *             {
 *                 SecureBootEnabled = true,
 *             },
 *         },
 *         StorageProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesStorageProfileArgs
 *         {
 *             OsDisk = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesOsDiskArgs
 *             {
 *                 Id = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/virtualHardDisks/test-vhd",
 *             },
 *             VmConfigStoragePathId = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container",
 *         },
 *         VirtualMachineName = "test-vm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewVirtualMachine(ctx, "virtualMachine", &azurestackhci.VirtualMachineArgs{
 * 			ExtendedLocation: &azurestackhci.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			HardwareProfile: &azurestackhci.VirtualMachinePropertiesHardwareProfileArgs{
 * 				VmSize: pulumi.String("Default"),
 * 			},
 * 			Location: pulumi.String("West US2"),
 * 			NetworkProfile: azurestackhci.VirtualMachinePropertiesResponseNetworkProfile{
 * 				NetworkInterfaces: azurestackhci.VirtualMachinePropertiesNetworkInterfacesArray{
 * 					&azurestackhci.VirtualMachinePropertiesNetworkInterfacesArgs{
 * 						Id: pulumi.String("test-nic"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			SecurityProfile: azurestackhci.VirtualMachinePropertiesResponseSecurityProfile{
 * 				EnableTPM: pulumi.Bool(true),
 * 				UefiSettings: &azurestackhci.VirtualMachinePropertiesUefiSettingsArgs{
 * 					SecureBootEnabled: pulumi.Bool(true),
 * 				},
 * 			},
 * 			StorageProfile: azurestackhci.VirtualMachinePropertiesResponseStorageProfile{
 * 				OsDisk: &azurestackhci.VirtualMachinePropertiesOsDiskArgs{
 * 					Id: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/virtualHardDisks/test-vhd"),
 * 				},
 * 				VmConfigStoragePathId: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container"),
 * 			},
 * 			VirtualMachineName: pulumi.String("test-vm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.VirtualMachine;
 * import com.pulumi.azurenative.azurestackhci.VirtualMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .hardwareProfile(Map.of("vmSize", "Default"))
 *             .location("West US2")
 *             .networkProfile(Map.of("networkInterfaces", Map.of("id", "test-nic")))
 *             .resourceGroupName("test-rg")
 *             .securityProfile(Map.ofEntries(
 *                 Map.entry("enableTPM", true),
 *                 Map.entry("uefiSettings", Map.of("secureBootEnabled", true))
 *             ))
 *             .storageProfile(Map.ofEntries(
 *                 Map.entry("osDisk", Map.of("id", "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/virtualHardDisks/test-vhd")),
 *                 Map.entry("vmConfigStoragePathId", "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container")
 *             ))
 *             .virtualMachineName("test-vm")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:VirtualMachine myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/virtualMachines/{virtualMachineName}
 * ```
 * @property extendedLocation The extendedLocation of the resource.
 * @property hardwareProfile HardwareProfile - Specifies the hardware settings for the virtual machine.
 * @property identity Identity for the resource.
 * @property location The geo-location where the resource lives
 * @property networkProfile NetworkProfile - describes the network configuration the virtual machine
 * @property osProfile OsProfile - describes the configuration of the operating system and sets login data
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property securityProfile SecurityProfile - Specifies the security settings for the virtual machine.
 * @property storageProfile StorageProfile - contains information about the disks and storage information for the virtual machine
 * @property tags Resource tags.
 * @property virtualMachineName Name of the virtual machine
 */
public data class VirtualMachineArgs(
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val hardwareProfile: Output<VirtualMachinePropertiesHardwareProfileArgs>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val networkProfile: Output<VirtualMachinePropertiesNetworkProfileArgs>? = null,
    public val osProfile: Output<VirtualMachinePropertiesOsProfileArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val securityProfile: Output<VirtualMachinePropertiesSecurityProfileArgs>? = null,
    public val storageProfile: Output<VirtualMachinePropertiesStorageProfileArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val virtualMachineName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.VirtualMachineArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.VirtualMachineArgs =
        com.pulumi.azurenative.azurestackhci.VirtualMachineArgs.builder()
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hardwareProfile(hardwareProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .networkProfile(networkProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .osProfile(osProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .securityProfile(securityProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageProfile(storageProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualMachineName(virtualMachineName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineArgs].
 */
@PulumiTagMarker
public class VirtualMachineArgsBuilder internal constructor() {
    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var hardwareProfile: Output<VirtualMachinePropertiesHardwareProfileArgs>? = null

    private var identity: Output<IdentityArgs>? = null

    private var location: Output<String>? = null

    private var networkProfile: Output<VirtualMachinePropertiesNetworkProfileArgs>? = null

    private var osProfile: Output<VirtualMachinePropertiesOsProfileArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var securityProfile: Output<VirtualMachinePropertiesSecurityProfileArgs>? = null

    private var storageProfile: Output<VirtualMachinePropertiesStorageProfileArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var virtualMachineName: Output<String>? = null

    /**
     * @param value The extendedLocation of the resource.
     */
    @JvmName("luqoqsxjkmqqschk")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value HardwareProfile - Specifies the hardware settings for the virtual machine.
     */
    @JvmName("olknotcntfisgmdf")
    public suspend fun hardwareProfile(`value`: Output<VirtualMachinePropertiesHardwareProfileArgs>) {
        this.hardwareProfile = value
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("roeuraujdtbbanaq")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("vepsnhprssojuger")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value NetworkProfile - describes the network configuration the virtual machine
     */
    @JvmName("qlremcxoutbwdbio")
    public suspend fun networkProfile(`value`: Output<VirtualMachinePropertiesNetworkProfileArgs>) {
        this.networkProfile = value
    }

    /**
     * @param value OsProfile - describes the configuration of the operating system and sets login data
     */
    @JvmName("xymotdsxogygslml")
    public suspend fun osProfile(`value`: Output<VirtualMachinePropertiesOsProfileArgs>) {
        this.osProfile = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wwkofriqbwjcutan")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value SecurityProfile - Specifies the security settings for the virtual machine.
     */
    @JvmName("ncjlnwtnispprhtk")
    public suspend fun securityProfile(`value`: Output<VirtualMachinePropertiesSecurityProfileArgs>) {
        this.securityProfile = value
    }

    /**
     * @param value StorageProfile - contains information about the disks and storage information for the virtual machine
     */
    @JvmName("ayisodvbnfvojyif")
    public suspend fun storageProfile(`value`: Output<VirtualMachinePropertiesStorageProfileArgs>) {
        this.storageProfile = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("yskirlsetqhwhluo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the virtual machine
     */
    @JvmName("xlticugnfmsutlht")
    public suspend fun virtualMachineName(`value`: Output<String>) {
        this.virtualMachineName = value
    }

    /**
     * @param value The extendedLocation of the resource.
     */
    @JvmName("rwhfmjbcucgujaht")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extendedLocation of the resource.
     */
    @JvmName("lltmtwirhixrprbk")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value HardwareProfile - Specifies the hardware settings for the virtual machine.
     */
    @JvmName("rntsbqlikcccyfca")
    public suspend fun hardwareProfile(`value`: VirtualMachinePropertiesHardwareProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hardwareProfile = mapped
    }

    /**
     * @param argument HardwareProfile - Specifies the hardware settings for the virtual machine.
     */
    @JvmName("owkfbqvuxrgbwwje")
    public suspend
    fun hardwareProfile(argument: suspend VirtualMachinePropertiesHardwareProfileArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachinePropertiesHardwareProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.hardwareProfile = mapped
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("nkcoaqvsftbxqdas")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity for the resource.
     */
    @JvmName("vlpvlacmrbenjctr")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("dogxegfxahfjrqxu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value NetworkProfile - describes the network configuration the virtual machine
     */
    @JvmName("ugwafigxgxpolxbo")
    public suspend fun networkProfile(`value`: VirtualMachinePropertiesNetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkProfile = mapped
    }

    /**
     * @param argument NetworkProfile - describes the network configuration the virtual machine
     */
    @JvmName("qjckwgpecjeaddvr")
    public suspend
    fun networkProfile(argument: suspend VirtualMachinePropertiesNetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachinePropertiesNetworkProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.networkProfile = mapped
    }

    /**
     * @param value OsProfile - describes the configuration of the operating system and sets login data
     */
    @JvmName("ihsqrdnpdiunyttl")
    public suspend fun osProfile(`value`: VirtualMachinePropertiesOsProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osProfile = mapped
    }

    /**
     * @param argument OsProfile - describes the configuration of the operating system and sets login data
     */
    @JvmName("ykiveswtyulidsik")
    public suspend
    fun osProfile(argument: suspend VirtualMachinePropertiesOsProfileArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachinePropertiesOsProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.osProfile = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ruhuwxvquvbxftpd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value SecurityProfile - Specifies the security settings for the virtual machine.
     */
    @JvmName("faxjwgxnysyugacy")
    public suspend fun securityProfile(`value`: VirtualMachinePropertiesSecurityProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityProfile = mapped
    }

    /**
     * @param argument SecurityProfile - Specifies the security settings for the virtual machine.
     */
    @JvmName("mujmpeudjhaggajo")
    public suspend
    fun securityProfile(argument: suspend VirtualMachinePropertiesSecurityProfileArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachinePropertiesSecurityProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.securityProfile = mapped
    }

    /**
     * @param value StorageProfile - contains information about the disks and storage information for the virtual machine
     */
    @JvmName("unqxraopxhtnibtu")
    public suspend fun storageProfile(`value`: VirtualMachinePropertiesStorageProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageProfile = mapped
    }

    /**
     * @param argument StorageProfile - contains information about the disks and storage information for the virtual machine
     */
    @JvmName("xgmrahieufsyhano")
    public suspend
    fun storageProfile(argument: suspend VirtualMachinePropertiesStorageProfileArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachinePropertiesStorageProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.storageProfile = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jcfnxfuwyyqigeos")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("urotvlbwiawpekvx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Name of the virtual machine
     */
    @JvmName("deaurquikhklymrw")
    public suspend fun virtualMachineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachineName = mapped
    }

    internal fun build(): VirtualMachineArgs = VirtualMachineArgs(
        extendedLocation = extendedLocation,
        hardwareProfile = hardwareProfile,
        identity = identity,
        location = location,
        networkProfile = networkProfile,
        osProfile = osProfile,
        resourceGroupName = resourceGroupName,
        securityProfile = securityProfile,
        storageProfile = storageProfile,
        tags = tags,
        virtualMachineName = virtualMachineName,
    )
}
