@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.VirtualMachineInstanceArgs.builder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.VirtualMachineInstancePropertiesHardwareProfileArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.VirtualMachineInstancePropertiesHardwareProfileArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.VirtualMachineInstancePropertiesNetworkProfileArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.VirtualMachineInstancePropertiesNetworkProfileArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.VirtualMachineInstancePropertiesOsProfileArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.VirtualMachineInstancePropertiesOsProfileArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.VirtualMachineInstancePropertiesSecurityProfileArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.VirtualMachineInstancePropertiesSecurityProfileArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.VirtualMachineInstancePropertiesStorageProfileArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.VirtualMachineInstancePropertiesStorageProfileArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The virtual machine instance resource definition.
 * Azure REST API version: 2023-07-01-preview.
 * Other available API versions: 2023-09-01-preview.
 * ## Example Usage
 * ### PutVirtualMachineInstanceWithGalleryImage
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineInstance = new AzureNative.AzureStackHCI.VirtualMachineInstance("virtualMachineInstance", new()
 *     {
 *         ExtendedLocation = new AzureNative.AzureStackHCI.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location",
 *             Type = "CustomLocation",
 *         },
 *         HardwareProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesHardwareProfileArgs
 *         {
 *             VmSize = "Default",
 *         },
 *         NetworkProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesNetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesNetworkInterfacesArgs
 *                 {
 *                     Id = "test-nic",
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesOsProfileArgs
 *         {
 *             AdminPassword = "password",
 *             AdminUsername = "localadmin",
 *             ComputerName = "luamaster",
 *         },
 *         ResourceUri = "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM",
 *         SecurityProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesSecurityProfileArgs
 *         {
 *             EnableTPM = true,
 *             UefiSettings = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesUefiSettingsArgs
 *             {
 *                 SecureBootEnabled = true,
 *             },
 *         },
 *         StorageProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesStorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesImageReferenceArgs
 *             {
 *                 Id = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/galleryImages/test-gallery-image",
 *             },
 *             VmConfigStoragePathId = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewVirtualMachineInstance(ctx, "virtualMachineInstance", &azurestackhci.VirtualMachineInstanceArgs{
 * 			ExtendedLocation: &azurestackhci.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			HardwareProfile: &azurestackhci.VirtualMachineInstancePropertiesHardwareProfileArgs{
 * 				VmSize: pulumi.String("Default"),
 * 			},
 * 			NetworkProfile: azurestackhci.VirtualMachineInstancePropertiesResponseNetworkProfile{
 * 				NetworkInterfaces: azurestackhci.VirtualMachineInstancePropertiesNetworkInterfacesArray{
 * 					&azurestackhci.VirtualMachineInstancePropertiesNetworkInterfacesArgs{
 * 						Id: pulumi.String("test-nic"),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &azurestackhci.VirtualMachineInstancePropertiesOsProfileArgs{
 * 				AdminPassword: pulumi.String("password"),
 * 				AdminUsername: pulumi.String("localadmin"),
 * 				ComputerName:  pulumi.String("luamaster"),
 * 			},
 * 			ResourceUri: pulumi.String("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM"),
 * 			SecurityProfile: azurestackhci.VirtualMachineInstancePropertiesResponseSecurityProfile{
 * 				EnableTPM: pulumi.Bool(true),
 * 				UefiSettings: &azurestackhci.VirtualMachineInstancePropertiesUefiSettingsArgs{
 * 					SecureBootEnabled: pulumi.Bool(true),
 * 				},
 * 			},
 * 			StorageProfile: azurestackhci.VirtualMachineInstancePropertiesResponseStorageProfile{
 * 				ImageReference: &azurestackhci.VirtualMachineInstancePropertiesImageReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/galleryImages/test-gallery-image"),
 * 				},
 * 				VmConfigStoragePathId: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.VirtualMachineInstance;
 * import com.pulumi.azurenative.azurestackhci.VirtualMachineInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineInstance = new VirtualMachineInstance("virtualMachineInstance", VirtualMachineInstanceArgs.builder()
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .hardwareProfile(Map.of("vmSize", "Default"))
 *             .networkProfile(Map.of("networkInterfaces", Map.of("id", "test-nic")))
 *             .osProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "password"),
 *                 Map.entry("adminUsername", "localadmin"),
 *                 Map.entry("computerName", "luamaster")
 *             ))
 *             .resourceUri("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM")
 *             .securityProfile(Map.ofEntries(
 *                 Map.entry("enableTPM", true),
 *                 Map.entry("uefiSettings", Map.of("secureBootEnabled", true))
 *             ))
 *             .storageProfile(Map.ofEntries(
 *                 Map.entry("imageReference", Map.of("id", "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/galleryImages/test-gallery-image")),
 *                 Map.entry("vmConfigStoragePathId", "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### PutVirtualMachineInstanceWithMarketplaceGalleryImage
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineInstance = new AzureNative.AzureStackHCI.VirtualMachineInstance("virtualMachineInstance", new()
 *     {
 *         ExtendedLocation = new AzureNative.AzureStackHCI.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location",
 *             Type = "CustomLocation",
 *         },
 *         HardwareProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesHardwareProfileArgs
 *         {
 *             VmSize = "Default",
 *         },
 *         NetworkProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesNetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesNetworkInterfacesArgs
 *                 {
 *                     Id = "test-nic",
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesOsProfileArgs
 *         {
 *             AdminPassword = "password",
 *             AdminUsername = "localadmin",
 *             ComputerName = "luamaster",
 *         },
 *         ResourceUri = "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM",
 *         SecurityProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesSecurityProfileArgs
 *         {
 *             EnableTPM = true,
 *             UefiSettings = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesUefiSettingsArgs
 *             {
 *                 SecureBootEnabled = true,
 *             },
 *         },
 *         StorageProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesStorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesImageReferenceArgs
 *             {
 *                 Id = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/marketplaceGalleryImages/test-marketplace-gallery-image",
 *             },
 *             VmConfigStoragePathId = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewVirtualMachineInstance(ctx, "virtualMachineInstance", &azurestackhci.VirtualMachineInstanceArgs{
 * 			ExtendedLocation: &azurestackhci.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			HardwareProfile: &azurestackhci.VirtualMachineInstancePropertiesHardwareProfileArgs{
 * 				VmSize: pulumi.String("Default"),
 * 			},
 * 			NetworkProfile: azurestackhci.VirtualMachineInstancePropertiesResponseNetworkProfile{
 * 				NetworkInterfaces: azurestackhci.VirtualMachineInstancePropertiesNetworkInterfacesArray{
 * 					&azurestackhci.VirtualMachineInstancePropertiesNetworkInterfacesArgs{
 * 						Id: pulumi.String("test-nic"),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &azurestackhci.VirtualMachineInstancePropertiesOsProfileArgs{
 * 				AdminPassword: pulumi.String("password"),
 * 				AdminUsername: pulumi.String("localadmin"),
 * 				ComputerName:  pulumi.String("luamaster"),
 * 			},
 * 			ResourceUri: pulumi.String("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM"),
 * 			SecurityProfile: azurestackhci.VirtualMachineInstancePropertiesResponseSecurityProfile{
 * 				EnableTPM: pulumi.Bool(true),
 * 				UefiSettings: &azurestackhci.VirtualMachineInstancePropertiesUefiSettingsArgs{
 * 					SecureBootEnabled: pulumi.Bool(true),
 * 				},
 * 			},
 * 			StorageProfile: azurestackhci.VirtualMachineInstancePropertiesResponseStorageProfile{
 * 				ImageReference: &azurestackhci.VirtualMachineInstancePropertiesImageReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/marketplaceGalleryImages/test-marketplace-gallery-image"),
 * 				},
 * 				VmConfigStoragePathId: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.VirtualMachineInstance;
 * import com.pulumi.azurenative.azurestackhci.VirtualMachineInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineInstance = new VirtualMachineInstance("virtualMachineInstance", VirtualMachineInstanceArgs.builder()
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .hardwareProfile(Map.of("vmSize", "Default"))
 *             .networkProfile(Map.of("networkInterfaces", Map.of("id", "test-nic")))
 *             .osProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "password"),
 *                 Map.entry("adminUsername", "localadmin"),
 *                 Map.entry("computerName", "luamaster")
 *             ))
 *             .resourceUri("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM")
 *             .securityProfile(Map.ofEntries(
 *                 Map.entry("enableTPM", true),
 *                 Map.entry("uefiSettings", Map.of("secureBootEnabled", true))
 *             ))
 *             .storageProfile(Map.ofEntries(
 *                 Map.entry("imageReference", Map.of("id", "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/marketplaceGalleryImages/test-marketplace-gallery-image")),
 *                 Map.entry("vmConfigStoragePathId", "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### PutVirtualMachineInstanceWithOsDisk
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineInstance = new AzureNative.AzureStackHCI.VirtualMachineInstance("virtualMachineInstance", new()
 *     {
 *         ExtendedLocation = new AzureNative.AzureStackHCI.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location",
 *             Type = "CustomLocation",
 *         },
 *         HardwareProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesHardwareProfileArgs
 *         {
 *             VmSize = "Default",
 *         },
 *         NetworkProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesNetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesNetworkInterfacesArgs
 *                 {
 *                     Id = "test-nic",
 *                 },
 *             },
 *         },
 *         ResourceUri = "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM",
 *         SecurityProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesSecurityProfileArgs
 *         {
 *             EnableTPM = true,
 *             UefiSettings = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesUefiSettingsArgs
 *             {
 *                 SecureBootEnabled = true,
 *             },
 *         },
 *         StorageProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesStorageProfileArgs
 *         {
 *             OsDisk = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesOsDiskArgs
 *             {
 *                 Id = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/virtualHardDisks/test-vhd",
 *             },
 *             VmConfigStoragePathId = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewVirtualMachineInstance(ctx, "virtualMachineInstance", &azurestackhci.VirtualMachineInstanceArgs{
 * 			ExtendedLocation: &azurestackhci.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			HardwareProfile: &azurestackhci.VirtualMachineInstancePropertiesHardwareProfileArgs{
 * 				VmSize: pulumi.String("Default"),
 * 			},
 * 			NetworkProfile: azurestackhci.VirtualMachineInstancePropertiesResponseNetworkProfile{
 * 				NetworkInterfaces: azurestackhci.VirtualMachineInstancePropertiesNetworkInterfacesArray{
 * 					&azurestackhci.VirtualMachineInstancePropertiesNetworkInterfacesArgs{
 * 						Id: pulumi.String("test-nic"),
 * 					},
 * 				},
 * 			},
 * 			ResourceUri: pulumi.String("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM"),
 * 			SecurityProfile: azurestackhci.VirtualMachineInstancePropertiesResponseSecurityProfile{
 * 				EnableTPM: pulumi.Bool(true),
 * 				UefiSettings: &azurestackhci.VirtualMachineInstancePropertiesUefiSettingsArgs{
 * 					SecureBootEnabled: pulumi.Bool(true),
 * 				},
 * 			},
 * 			StorageProfile: azurestackhci.VirtualMachineInstancePropertiesResponseStorageProfile{
 * 				OsDisk: &azurestackhci.VirtualMachineInstancePropertiesOsDiskArgs{
 * 					Id: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/virtualHardDisks/test-vhd"),
 * 				},
 * 				VmConfigStoragePathId: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.VirtualMachineInstance;
 * import com.pulumi.azurenative.azurestackhci.VirtualMachineInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineInstance = new VirtualMachineInstance("virtualMachineInstance", VirtualMachineInstanceArgs.builder()
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .hardwareProfile(Map.of("vmSize", "Default"))
 *             .networkProfile(Map.of("networkInterfaces", Map.of("id", "test-nic")))
 *             .resourceUri("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM")
 *             .securityProfile(Map.ofEntries(
 *                 Map.entry("enableTPM", true),
 *                 Map.entry("uefiSettings", Map.of("secureBootEnabled", true))
 *             ))
 *             .storageProfile(Map.ofEntries(
 *                 Map.entry("osDisk", Map.of("id", "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/virtualHardDisks/test-vhd")),
 *                 Map.entry("vmConfigStoragePathId", "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### PutVirtualMachineInstanceWithVMConfigAgent
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineInstance = new AzureNative.AzureStackHCI.VirtualMachineInstance("virtualMachineInstance", new()
 *     {
 *         ExtendedLocation = new AzureNative.AzureStackHCI.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location",
 *             Type = "CustomLocation",
 *         },
 *         HardwareProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesHardwareProfileArgs
 *         {
 *             VmSize = "Default",
 *         },
 *         NetworkProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesNetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesNetworkInterfacesArgs
 *                 {
 *                     Id = "test-nic",
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesOsProfileArgs
 *         {
 *             AdminPassword = "password",
 *             AdminUsername = "localadmin",
 *             ComputerName = "luamaster",
 *             WindowsConfiguration = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesWindowsConfigurationArgs
 *             {
 *                 ProvisionVMConfigAgent = true,
 *             },
 *         },
 *         ResourceUri = "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM",
 *         SecurityProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesSecurityProfileArgs
 *         {
 *             EnableTPM = true,
 *             UefiSettings = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesUefiSettingsArgs
 *             {
 *                 SecureBootEnabled = true,
 *             },
 *         },
 *         StorageProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesStorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.AzureStackHCI.Inputs.VirtualMachineInstancePropertiesImageReferenceArgs
 *             {
 *                 Id = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/galleryImages/test-gallery-image",
 *             },
 *             VmConfigStoragePathId = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewVirtualMachineInstance(ctx, "virtualMachineInstance", &azurestackhci.VirtualMachineInstanceArgs{
 * 			ExtendedLocation: &azurestackhci.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			HardwareProfile: &azurestackhci.VirtualMachineInstancePropertiesHardwareProfileArgs{
 * 				VmSize: pulumi.String("Default"),
 * 			},
 * 			NetworkProfile: azurestackhci.VirtualMachineInstancePropertiesResponseNetworkProfile{
 * 				NetworkInterfaces: azurestackhci.VirtualMachineInstancePropertiesNetworkInterfacesArray{
 * 					&azurestackhci.VirtualMachineInstancePropertiesNetworkInterfacesArgs{
 * 						Id: pulumi.String("test-nic"),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: azurestackhci.VirtualMachineInstancePropertiesResponseOsProfile{
 * 				AdminPassword: pulumi.String("password"),
 * 				AdminUsername: pulumi.String("localadmin"),
 * 				ComputerName:  pulumi.String("luamaster"),
 * 				WindowsConfiguration: &azurestackhci.VirtualMachineInstancePropertiesWindowsConfigurationArgs{
 * 					ProvisionVMConfigAgent: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceUri: pulumi.String("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM"),
 * 			SecurityProfile: azurestackhci.VirtualMachineInstancePropertiesResponseSecurityProfile{
 * 				EnableTPM: pulumi.Bool(true),
 * 				UefiSettings: &azurestackhci.VirtualMachineInstancePropertiesUefiSettingsArgs{
 * 					SecureBootEnabled: pulumi.Bool(true),
 * 				},
 * 			},
 * 			StorageProfile: azurestackhci.VirtualMachineInstancePropertiesResponseStorageProfile{
 * 				ImageReference: &azurestackhci.VirtualMachineInstancePropertiesImageReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/galleryImages/test-gallery-image"),
 * 				},
 * 				VmConfigStoragePathId: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.VirtualMachineInstance;
 * import com.pulumi.azurenative.azurestackhci.VirtualMachineInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineInstance = new VirtualMachineInstance("virtualMachineInstance", VirtualMachineInstanceArgs.builder()
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .hardwareProfile(Map.of("vmSize", "Default"))
 *             .networkProfile(Map.of("networkInterfaces", Map.of("id", "test-nic")))
 *             .osProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "password"),
 *                 Map.entry("adminUsername", "localadmin"),
 *                 Map.entry("computerName", "luamaster"),
 *                 Map.entry("windowsConfiguration", Map.of("provisionVMConfigAgent", true))
 *             ))
 *             .resourceUri("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM")
 *             .securityProfile(Map.ofEntries(
 *                 Map.entry("enableTPM", true),
 *                 Map.entry("uefiSettings", Map.of("secureBootEnabled", true))
 *             ))
 *             .storageProfile(Map.ofEntries(
 *                 Map.entry("imageReference", Map.of("id", "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/galleryImages/test-gallery-image")),
 *                 Map.entry("vmConfigStoragePathId", "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:VirtualMachineInstance myresource1 /{resourceUri}/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default
 * ```
 * @property extendedLocation The extendedLocation of the resource.
 * @property hardwareProfile HardwareProfile - Specifies the hardware settings for the virtual machine instance.
 * @property identity Identity for the resource.
 * @property networkProfile NetworkProfile - describes the network configuration the virtual machine instance
 * @property osProfile OsProfile - describes the configuration of the operating system and sets login data
 * @property resourceUid Unique identifier defined by ARC to identify the guest of the VM.
 * @property resourceUri The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
 * @property securityProfile SecurityProfile - Specifies the security settings for the virtual machine instance.
 * @property storageProfile StorageProfile - contains information about the disks and storage information for the virtual machine instance
 */
public data class VirtualMachineInstanceArgs(
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val hardwareProfile: Output<VirtualMachineInstancePropertiesHardwareProfileArgs>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val networkProfile: Output<VirtualMachineInstancePropertiesNetworkProfileArgs>? = null,
    public val osProfile: Output<VirtualMachineInstancePropertiesOsProfileArgs>? = null,
    public val resourceUid: Output<String>? = null,
    public val resourceUri: Output<String>? = null,
    public val securityProfile: Output<VirtualMachineInstancePropertiesSecurityProfileArgs>? = null,
    public val storageProfile: Output<VirtualMachineInstancePropertiesStorageProfileArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.VirtualMachineInstanceArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.VirtualMachineInstanceArgs =
        com.pulumi.azurenative.azurestackhci.VirtualMachineInstanceArgs.builder()
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hardwareProfile(hardwareProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .networkProfile(networkProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .osProfile(osProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceUid(resourceUid?.applyValue({ args0 -> args0 }))
            .resourceUri(resourceUri?.applyValue({ args0 -> args0 }))
            .securityProfile(securityProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageProfile(
                storageProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualMachineInstanceArgs].
 */
@PulumiTagMarker
public class VirtualMachineInstanceArgsBuilder internal constructor() {
    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var hardwareProfile: Output<VirtualMachineInstancePropertiesHardwareProfileArgs>? = null

    private var identity: Output<IdentityArgs>? = null

    private var networkProfile: Output<VirtualMachineInstancePropertiesNetworkProfileArgs>? = null

    private var osProfile: Output<VirtualMachineInstancePropertiesOsProfileArgs>? = null

    private var resourceUid: Output<String>? = null

    private var resourceUri: Output<String>? = null

    private var securityProfile: Output<VirtualMachineInstancePropertiesSecurityProfileArgs>? = null

    private var storageProfile: Output<VirtualMachineInstancePropertiesStorageProfileArgs>? = null

    /**
     * @param value The extendedLocation of the resource.
     */
    @JvmName("adhrtyrfhkckrmaw")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value HardwareProfile - Specifies the hardware settings for the virtual machine instance.
     */
    @JvmName("unwwcluxvtmipefa")
    public suspend
    fun hardwareProfile(`value`: Output<VirtualMachineInstancePropertiesHardwareProfileArgs>) {
        this.hardwareProfile = value
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("pytxolxtwuvovccc")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value NetworkProfile - describes the network configuration the virtual machine instance
     */
    @JvmName("jdoootuhnevdinft")
    public suspend
    fun networkProfile(`value`: Output<VirtualMachineInstancePropertiesNetworkProfileArgs>) {
        this.networkProfile = value
    }

    /**
     * @param value OsProfile - describes the configuration of the operating system and sets login data
     */
    @JvmName("ucmfckcqdqidrvag")
    public suspend fun osProfile(`value`: Output<VirtualMachineInstancePropertiesOsProfileArgs>) {
        this.osProfile = value
    }

    /**
     * @param value Unique identifier defined by ARC to identify the guest of the VM.
     */
    @JvmName("aiqdgvxrorvakxus")
    public suspend fun resourceUid(`value`: Output<String>) {
        this.resourceUid = value
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
     */
    @JvmName("tctvdqdwbfpnvucd")
    public suspend fun resourceUri(`value`: Output<String>) {
        this.resourceUri = value
    }

    /**
     * @param value SecurityProfile - Specifies the security settings for the virtual machine instance.
     */
    @JvmName("emhpstcadmurokei")
    public suspend
    fun securityProfile(`value`: Output<VirtualMachineInstancePropertiesSecurityProfileArgs>) {
        this.securityProfile = value
    }

    /**
     * @param value StorageProfile - contains information about the disks and storage information for the virtual machine instance
     */
    @JvmName("poqqoeivjagtqtxk")
    public suspend
    fun storageProfile(`value`: Output<VirtualMachineInstancePropertiesStorageProfileArgs>) {
        this.storageProfile = value
    }

    /**
     * @param value The extendedLocation of the resource.
     */
    @JvmName("ouagovfbtnxywmta")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extendedLocation of the resource.
     */
    @JvmName("eibgodawxqmghkej")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value HardwareProfile - Specifies the hardware settings for the virtual machine instance.
     */
    @JvmName("lqbadfjknumihnml")
    public suspend
    fun hardwareProfile(`value`: VirtualMachineInstancePropertiesHardwareProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hardwareProfile = mapped
    }

    /**
     * @param argument HardwareProfile - Specifies the hardware settings for the virtual machine instance.
     */
    @JvmName("hulfamsetmrvhqnt")
    public suspend
    fun hardwareProfile(argument: suspend VirtualMachineInstancePropertiesHardwareProfileArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineInstancePropertiesHardwareProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.hardwareProfile = mapped
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("swfyvbinihrpxpkm")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity for the resource.
     */
    @JvmName("yvtfsrjwsxaktrmu")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value NetworkProfile - describes the network configuration the virtual machine instance
     */
    @JvmName("aqjyllucbwxhqonr")
    public suspend fun networkProfile(`value`: VirtualMachineInstancePropertiesNetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkProfile = mapped
    }

    /**
     * @param argument NetworkProfile - describes the network configuration the virtual machine instance
     */
    @JvmName("lulkffqbxiqdbyva")
    public suspend
    fun networkProfile(argument: suspend VirtualMachineInstancePropertiesNetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineInstancePropertiesNetworkProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.networkProfile = mapped
    }

    /**
     * @param value OsProfile - describes the configuration of the operating system and sets login data
     */
    @JvmName("mctixpysmhyoknvw")
    public suspend fun osProfile(`value`: VirtualMachineInstancePropertiesOsProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osProfile = mapped
    }

    /**
     * @param argument OsProfile - describes the configuration of the operating system and sets login data
     */
    @JvmName("asujggqtkighvpcb")
    public suspend
    fun osProfile(argument: suspend VirtualMachineInstancePropertiesOsProfileArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineInstancePropertiesOsProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.osProfile = mapped
    }

    /**
     * @param value Unique identifier defined by ARC to identify the guest of the VM.
     */
    @JvmName("ksqyhysxesstgwol")
    public suspend fun resourceUid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUid = mapped
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
     */
    @JvmName("myfcbsqkscrpgvxm")
    public suspend fun resourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUri = mapped
    }

    /**
     * @param value SecurityProfile - Specifies the security settings for the virtual machine instance.
     */
    @JvmName("fvopfapmpytxlgrv")
    public suspend
    fun securityProfile(`value`: VirtualMachineInstancePropertiesSecurityProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityProfile = mapped
    }

    /**
     * @param argument SecurityProfile - Specifies the security settings for the virtual machine instance.
     */
    @JvmName("nlecdhiftvdilvji")
    public suspend
    fun securityProfile(argument: suspend VirtualMachineInstancePropertiesSecurityProfileArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineInstancePropertiesSecurityProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.securityProfile = mapped
    }

    /**
     * @param value StorageProfile - contains information about the disks and storage information for the virtual machine instance
     */
    @JvmName("fdvqehfraaptfkra")
    public suspend fun storageProfile(`value`: VirtualMachineInstancePropertiesStorageProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageProfile = mapped
    }

    /**
     * @param argument StorageProfile - contains information about the disks and storage information for the virtual machine instance
     */
    @JvmName("gsggdlpnhwadiyes")
    public suspend
    fun storageProfile(argument: suspend VirtualMachineInstancePropertiesStorageProfileArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineInstancePropertiesStorageProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.storageProfile = mapped
    }

    internal fun build(): VirtualMachineInstanceArgs = VirtualMachineInstanceArgs(
        extendedLocation = extendedLocation,
        hardwareProfile = hardwareProfile,
        identity = identity,
        networkProfile = networkProfile,
        osProfile = osProfile,
        resourceUid = resourceUid,
        resourceUri = resourceUri,
        securityProfile = securityProfile,
        storageProfile = storageProfile,
    )
}
