@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.ClusterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * AzureStackHCI Cluster deployment properties.
 * @property azureServiceEndpoint For Azure blob service endpoint type, select either Default or Custom domain. If you selected **Custom domain, enter the domain for the blob service in this format core.windows.net.
 * @property cloudAccountName Specify the Azure Storage account name for cloud witness for your Azure Stack HCI cluster.
 * @property name The cluster name provided when preparing Active Directory.
 * @property witnessPath Specify the fileshare path for the local witness for your Azure Stack HCI cluster.
 * @property witnessType Use a cloud witness if you have internet access and if you use an Azure Storage account to provide a vote on cluster quorum. A cloud witness uses Azure Blob Storage to read or write a blob file and then uses it to arbitrate in split-brain resolution. Only allowed values are 'Cloud', 'FileShare'.
 */
public data class ClusterArgs(
    public val azureServiceEndpoint: Output<String>? = null,
    public val cloudAccountName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val witnessPath: Output<String>? = null,
    public val witnessType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.ClusterArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.ClusterArgs =
        com.pulumi.azurenative.azurestackhci.inputs.ClusterArgs.builder()
            .azureServiceEndpoint(azureServiceEndpoint?.applyValue({ args0 -> args0 }))
            .cloudAccountName(cloudAccountName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .witnessPath(witnessPath?.applyValue({ args0 -> args0 }))
            .witnessType(witnessType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var azureServiceEndpoint: Output<String>? = null

    private var cloudAccountName: Output<String>? = null

    private var name: Output<String>? = null

    private var witnessPath: Output<String>? = null

    private var witnessType: Output<String>? = null

    /**
     * @param value For Azure blob service endpoint type, select either Default or Custom domain. If you selected **Custom domain, enter the domain for the blob service in this format core.windows.net.
     */
    @JvmName("aqstseyvtpbcenou")
    public suspend fun azureServiceEndpoint(`value`: Output<String>) {
        this.azureServiceEndpoint = value
    }

    /**
     * @param value Specify the Azure Storage account name for cloud witness for your Azure Stack HCI cluster.
     */
    @JvmName("oqfhlpoadhqkxuwe")
    public suspend fun cloudAccountName(`value`: Output<String>) {
        this.cloudAccountName = value
    }

    /**
     * @param value The cluster name provided when preparing Active Directory.
     */
    @JvmName("kxugayarkwsonqmo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specify the fileshare path for the local witness for your Azure Stack HCI cluster.
     */
    @JvmName("ciifmufmxwaxgpjv")
    public suspend fun witnessPath(`value`: Output<String>) {
        this.witnessPath = value
    }

    /**
     * @param value Use a cloud witness if you have internet access and if you use an Azure Storage account to provide a vote on cluster quorum. A cloud witness uses Azure Blob Storage to read or write a blob file and then uses it to arbitrate in split-brain resolution. Only allowed values are 'Cloud', 'FileShare'.
     */
    @JvmName("mbfpyjeiwsewgldm")
    public suspend fun witnessType(`value`: Output<String>) {
        this.witnessType = value
    }

    /**
     * @param value For Azure blob service endpoint type, select either Default or Custom domain. If you selected **Custom domain, enter the domain for the blob service in this format core.windows.net.
     */
    @JvmName("jhpindrljdfqrvvj")
    public suspend fun azureServiceEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureServiceEndpoint = mapped
    }

    /**
     * @param value Specify the Azure Storage account name for cloud witness for your Azure Stack HCI cluster.
     */
    @JvmName("kxkiawuilunxqbat")
    public suspend fun cloudAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudAccountName = mapped
    }

    /**
     * @param value The cluster name provided when preparing Active Directory.
     */
    @JvmName("kehlnonxvnvhriiq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specify the fileshare path for the local witness for your Azure Stack HCI cluster.
     */
    @JvmName("vrksggslycutgrfq")
    public suspend fun witnessPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.witnessPath = mapped
    }

    /**
     * @param value Use a cloud witness if you have internet access and if you use an Azure Storage account to provide a vote on cluster quorum. A cloud witness uses Azure Blob Storage to read or write a blob file and then uses it to arbitrate in split-brain resolution. Only allowed values are 'Cloud', 'FileShare'.
     */
    @JvmName("katdmhtfktmhcvei")
    public suspend fun witnessType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.witnessType = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        azureServiceEndpoint = azureServiceEndpoint,
        cloudAccountName = cloudAccountName,
        name = name,
        witnessPath = witnessPath,
        witnessType = witnessType,
    )
}
