@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.ClusterDesiredPropertiesArgs.builder
import com.pulumi.azurenative.azurestackhci.kotlin.enums.DiagnosticLevel
import com.pulumi.azurenative.azurestackhci.kotlin.enums.WindowsServerSubscription
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Desired properties of the cluster.
 * @property diagnosticLevel Desired level of diagnostic data emitted by the cluster.
 * @property windowsServerSubscription Desired state of Windows Server Subscription.
 */
public data class ClusterDesiredPropertiesArgs(
    public val diagnosticLevel: Output<Either<String, DiagnosticLevel>>? = null,
    public val windowsServerSubscription: Output<Either<String, WindowsServerSubscription>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.ClusterDesiredPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.ClusterDesiredPropertiesArgs =
        com.pulumi.azurenative.azurestackhci.inputs.ClusterDesiredPropertiesArgs.builder()
            .diagnosticLevel(
                diagnosticLevel?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .windowsServerSubscription(
                windowsServerSubscription?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [ClusterDesiredPropertiesArgs].
 */
@PulumiTagMarker
public class ClusterDesiredPropertiesArgsBuilder internal constructor() {
    private var diagnosticLevel: Output<Either<String, DiagnosticLevel>>? = null

    private var windowsServerSubscription: Output<Either<String, WindowsServerSubscription>>? = null

    /**
     * @param value Desired level of diagnostic data emitted by the cluster.
     */
    @JvmName("xfdmimhrjgsrcwol")
    public suspend fun diagnosticLevel(`value`: Output<Either<String, DiagnosticLevel>>) {
        this.diagnosticLevel = value
    }

    /**
     * @param value Desired state of Windows Server Subscription.
     */
    @JvmName("mcwmacmaloblwiwd")
    public suspend
    fun windowsServerSubscription(`value`: Output<Either<String, WindowsServerSubscription>>) {
        this.windowsServerSubscription = value
    }

    /**
     * @param value Desired level of diagnostic data emitted by the cluster.
     */
    @JvmName("qpuuwtxvswdvjqkn")
    public suspend fun diagnosticLevel(`value`: Either<String, DiagnosticLevel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diagnosticLevel = mapped
    }

    /**
     * @param value Desired level of diagnostic data emitted by the cluster.
     */
    @JvmName("aysbtsbdcvlkyjed")
    public fun diagnosticLevel(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiagnosticLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diagnosticLevel = mapped
    }

    /**
     * @param value Desired level of diagnostic data emitted by the cluster.
     */
    @JvmName("awswxidsbiryavdd")
    public fun diagnosticLevel(`value`: DiagnosticLevel) {
        val toBeMapped = Either.ofRight<String, DiagnosticLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diagnosticLevel = mapped
    }

    /**
     * @param value Desired state of Windows Server Subscription.
     */
    @JvmName("lusukgcklqrstgje")
    public suspend
    fun windowsServerSubscription(`value`: Either<String, WindowsServerSubscription>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowsServerSubscription = mapped
    }

    /**
     * @param value Desired state of Windows Server Subscription.
     */
    @JvmName("nuyaxvofvuebahla")
    public fun windowsServerSubscription(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WindowsServerSubscription>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.windowsServerSubscription = mapped
    }

    /**
     * @param value Desired state of Windows Server Subscription.
     */
    @JvmName("qkaxdvoudcbigidt")
    public fun windowsServerSubscription(`value`: WindowsServerSubscription) {
        val toBeMapped = Either.ofRight<String, WindowsServerSubscription>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.windowsServerSubscription = mapped
    }

    internal fun build(): ClusterDesiredPropertiesArgs = ClusterDesiredPropertiesArgs(
        diagnosticLevel = diagnosticLevel,
        windowsServerSubscription = windowsServerSubscription,
    )
}
