@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.GetEdgeDevicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property edgeDeviceName Name of Device
 * @property resourceUri The fully qualified Azure Resource manager identifier of the resource.
 */
public data class GetEdgeDevicePlainArgs(
    public val edgeDeviceName: String,
    public val resourceUri: String,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.GetEdgeDevicePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.GetEdgeDevicePlainArgs =
        com.pulumi.azurenative.azurestackhci.inputs.GetEdgeDevicePlainArgs.builder()
            .edgeDeviceName(edgeDeviceName.let({ args0 -> args0 }))
            .resourceUri(resourceUri.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEdgeDevicePlainArgs].
 */
@PulumiTagMarker
public class GetEdgeDevicePlainArgsBuilder internal constructor() {
    private var edgeDeviceName: String? = null

    private var resourceUri: String? = null

    /**
     * @param value Name of Device
     */
    @JvmName("lmovvywdqxuiahmn")
    public suspend fun edgeDeviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.edgeDeviceName = mapped
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the resource.
     */
    @JvmName("kytqivsjyggecrcn")
    public suspend fun resourceUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceUri = mapped
    }

    internal fun build(): GetEdgeDevicePlainArgs = GetEdgeDevicePlainArgs(
        edgeDeviceName = edgeDeviceName ?: throw PulumiNullFieldException("edgeDeviceName"),
        resourceUri = resourceUri ?: throw PulumiNullFieldException("resourceUri"),
    )
}
