@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.GetMachineExtensionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property extensionName The name of the machine extension.
 * @property name The name of the machine containing the extension.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetMachineExtensionPlainArgs(
    public val extensionName: String,
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.GetMachineExtensionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.GetMachineExtensionPlainArgs =
        com.pulumi.azurenative.azurestackhci.inputs.GetMachineExtensionPlainArgs.builder()
            .extensionName(extensionName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMachineExtensionPlainArgs].
 */
@PulumiTagMarker
public class GetMachineExtensionPlainArgsBuilder internal constructor() {
    private var extensionName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the machine extension.
     */
    @JvmName("ogsmrpmfbweaixpg")
    public suspend fun extensionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.extensionName = mapped
    }

    /**
     * @param value The name of the machine containing the extension.
     */
    @JvmName("nmjenuxiyllfgspm")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("chwldabqiommebhk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetMachineExtensionPlainArgs = GetMachineExtensionPlainArgs(
        extensionName = extensionName ?: throw PulumiNullFieldException("extensionName"),
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
