@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.GetVirtualHardDiskPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property virtualHardDiskName Name of the virtual hard disk
 */
public data class GetVirtualHardDiskPlainArgs(
    public val resourceGroupName: String,
    public val virtualHardDiskName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.GetVirtualHardDiskPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.GetVirtualHardDiskPlainArgs =
        com.pulumi.azurenative.azurestackhci.inputs.GetVirtualHardDiskPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualHardDiskName(virtualHardDiskName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualHardDiskPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualHardDiskPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var virtualHardDiskName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("elynlqmhwpwxjgdi")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the virtual hard disk
     */
    @JvmName("evelmvamwsaakevw")
    public suspend fun virtualHardDiskName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualHardDiskName = mapped
    }

    internal fun build(): GetVirtualHardDiskPlainArgs = GetVirtualHardDiskPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        virtualHardDiskName = virtualHardDiskName ?: throw PulumiNullFieldException("virtualHardDiskName"),
    )
}
