@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.GetVirtualMachinePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property virtualMachineName Name of the virtual machine
 */
public data class GetVirtualMachinePlainArgs(
    public val resourceGroupName: String,
    public val virtualMachineName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.GetVirtualMachinePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.GetVirtualMachinePlainArgs =
        com.pulumi.azurenative.azurestackhci.inputs.GetVirtualMachinePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualMachineName(virtualMachineName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualMachinePlainArgs].
 */
@PulumiTagMarker
public class GetVirtualMachinePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var virtualMachineName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mpsikticybpsjbxh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the virtual machine
     */
    @JvmName("uolkfdpwdofvuibj")
    public suspend fun virtualMachineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualMachineName = mapped
    }

    internal fun build(): GetVirtualMachinePlainArgs = GetVirtualMachinePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        virtualMachineName = virtualMachineName ?: throw PulumiNullFieldException("virtualMachineName"),
    )
}
