@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.GetVirtualNetworkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property virtualNetworkName Name of the virtual network
 */
public data class GetVirtualNetworkPlainArgs(
    public val resourceGroupName: String,
    public val virtualNetworkName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.GetVirtualNetworkPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.GetVirtualNetworkPlainArgs =
        com.pulumi.azurenative.azurestackhci.inputs.GetVirtualNetworkPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualNetworkName(virtualNetworkName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualNetworkPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualNetworkPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var virtualNetworkName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fvoleddpamwdtlmm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the virtual network
     */
    @JvmName("uoolwyjmmgknuiqi")
    public suspend fun virtualNetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualNetworkName = mapped
    }

    internal fun build(): GetVirtualNetworkPlainArgs = GetVirtualNetworkPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        virtualNetworkName = virtualNetworkName ?: throw PulumiNullFieldException("virtualNetworkName"),
    )
}
