@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.IPConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * InterfaceIPConfiguration iPConfiguration in a network interface.
 * @property name Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property properties InterfaceIPConfigurationPropertiesFormat properties of IP configuration.
 */
public data class IPConfigurationArgs(
    public val name: Output<String>? = null,
    public val properties: Output<IPConfigurationPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.IPConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.IPConfigurationArgs =
        com.pulumi.azurenative.azurestackhci.inputs.IPConfigurationArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [IPConfigurationArgs].
 */
@PulumiTagMarker
public class IPConfigurationArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var properties: Output<IPConfigurationPropertiesArgs>? = null

    /**
     * @param value Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("mngojnecppqoxqev")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value InterfaceIPConfigurationPropertiesFormat properties of IP configuration.
     */
    @JvmName("nbwyafbnkcxvbctu")
    public suspend fun properties(`value`: Output<IPConfigurationPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("eklaogovugnbqnwk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value InterfaceIPConfigurationPropertiesFormat properties of IP configuration.
     */
    @JvmName("hhfsscxbjhvhnuvq")
    public suspend fun properties(`value`: IPConfigurationPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument InterfaceIPConfigurationPropertiesFormat properties of IP configuration.
     */
    @JvmName("fnvlrvjdgyehmkxs")
    public suspend fun properties(argument: suspend IPConfigurationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = IPConfigurationPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    internal fun build(): IPConfigurationArgs = IPConfigurationArgs(
        name = name,
        properties = properties,
    )
}
