@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.IPConfigurationPropertiesArgs.builder
import com.pulumi.azurenative.azurestackhci.kotlin.enums.PrivateIPAllocationMethodEnum
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * InterfaceIPConfigurationPropertiesFormat properties of IP configuration.
 * @property prefixLength prefixLength for network interface
 * @property privateIPAddress PrivateIPAddress - Private IP address of the IP configuration.
 * @property privateIPAllocationMethod PrivateIPAllocationMethod - The private IP address allocation method. Possible values include: 'Static', 'Dynamic'
 * @property subnet Subnet - Name of Subnet bound to the IP configuration.
 */
public data class IPConfigurationPropertiesArgs(
    public val prefixLength: Output<String>? = null,
    public val privateIPAddress: Output<String>? = null,
    public val privateIPAllocationMethod: Output<Either<String, PrivateIPAllocationMethodEnum>>? =
        null,
    public val subnet: Output<IPConfigurationSubnetArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.IPConfigurationPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.IPConfigurationPropertiesArgs =
        com.pulumi.azurenative.azurestackhci.inputs.IPConfigurationPropertiesArgs.builder()
            .prefixLength(prefixLength?.applyValue({ args0 -> args0 }))
            .privateIPAddress(privateIPAddress?.applyValue({ args0 -> args0 }))
            .privateIPAllocationMethod(
                privateIPAllocationMethod?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .subnet(subnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [IPConfigurationPropertiesArgs].
 */
@PulumiTagMarker
public class IPConfigurationPropertiesArgsBuilder internal constructor() {
    private var prefixLength: Output<String>? = null

    private var privateIPAddress: Output<String>? = null

    private var privateIPAllocationMethod: Output<Either<String, PrivateIPAllocationMethodEnum>>? =
        null

    private var subnet: Output<IPConfigurationSubnetArgs>? = null

    /**
     * @param value prefixLength for network interface
     */
    @JvmName("cdtjvtcjawvhjxaj")
    public suspend fun prefixLength(`value`: Output<String>) {
        this.prefixLength = value
    }

    /**
     * @param value PrivateIPAddress - Private IP address of the IP configuration.
     */
    @JvmName("htrrhnbulbanbknd")
    public suspend fun privateIPAddress(`value`: Output<String>) {
        this.privateIPAddress = value
    }

    /**
     * @param value PrivateIPAllocationMethod - The private IP address allocation method. Possible values include: 'Static', 'Dynamic'
     */
    @JvmName("esnirptbbytidvmm")
    public suspend
    fun privateIPAllocationMethod(`value`: Output<Either<String, PrivateIPAllocationMethodEnum>>) {
        this.privateIPAllocationMethod = value
    }

    /**
     * @param value Subnet - Name of Subnet bound to the IP configuration.
     */
    @JvmName("qmmjbhmbwyfpxcqd")
    public suspend fun subnet(`value`: Output<IPConfigurationSubnetArgs>) {
        this.subnet = value
    }

    /**
     * @param value prefixLength for network interface
     */
    @JvmName("grpsbuujoiqxxjmb")
    public suspend fun prefixLength(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixLength = mapped
    }

    /**
     * @param value PrivateIPAddress - Private IP address of the IP configuration.
     */
    @JvmName("teqioulcidemduqe")
    public suspend fun privateIPAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIPAddress = mapped
    }

    /**
     * @param value PrivateIPAllocationMethod - The private IP address allocation method. Possible values include: 'Static', 'Dynamic'
     */
    @JvmName("jakoinrsewcsviqc")
    public suspend
    fun privateIPAllocationMethod(`value`: Either<String, PrivateIPAllocationMethodEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value PrivateIPAllocationMethod - The private IP address allocation method. Possible values include: 'Static', 'Dynamic'
     */
    @JvmName("helnvkorwksllrnt")
    public fun privateIPAllocationMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PrivateIPAllocationMethodEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value PrivateIPAllocationMethod - The private IP address allocation method. Possible values include: 'Static', 'Dynamic'
     */
    @JvmName("sumoedgultsdladu")
    public fun privateIPAllocationMethod(`value`: PrivateIPAllocationMethodEnum) {
        val toBeMapped = Either.ofRight<String, PrivateIPAllocationMethodEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value Subnet - Name of Subnet bound to the IP configuration.
     */
    @JvmName("hfhschuvpagbwepo")
    public suspend fun subnet(`value`: IPConfigurationSubnetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument Subnet - Name of Subnet bound to the IP configuration.
     */
    @JvmName("ycqycskclmagfrqb")
    public suspend fun subnet(argument: suspend IPConfigurationSubnetArgsBuilder.() -> Unit) {
        val toBeMapped = IPConfigurationSubnetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    internal fun build(): IPConfigurationPropertiesArgs = IPConfigurationPropertiesArgs(
        prefixLength = prefixLength,
        privateIPAddress = privateIPAddress,
        privateIPAllocationMethod = privateIPAllocationMethod,
        subnet = subnet,
    )
}
