@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.NicDetailArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The NIC Detail of a device.
 * @property adapterName Adapter Name of NIC
 * @property componentId Component Id of NIC
 * @property defaultGateway Default Gateway of NIC
 * @property defaultIsolationId Default Isolation of Management NIC
 * @property dnsServers DNS Servers for NIC
 * @property driverVersion Driver Version of NIC
 * @property interfaceDescription Interface Description of NIC
 * @property ip4Address Subnet Mask of NIC
 * @property subnetMask Subnet Mask of NIC
 */
public data class NicDetailArgs(
    public val adapterName: Output<String>,
    public val componentId: Output<String>? = null,
    public val defaultGateway: Output<String>? = null,
    public val defaultIsolationId: Output<String>? = null,
    public val dnsServers: Output<List<String>>? = null,
    public val driverVersion: Output<String>? = null,
    public val interfaceDescription: Output<String>? = null,
    public val ip4Address: Output<String>? = null,
    public val subnetMask: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.NicDetailArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.NicDetailArgs =
        com.pulumi.azurenative.azurestackhci.inputs.NicDetailArgs.builder()
            .adapterName(adapterName.applyValue({ args0 -> args0 }))
            .componentId(componentId?.applyValue({ args0 -> args0 }))
            .defaultGateway(defaultGateway?.applyValue({ args0 -> args0 }))
            .defaultIsolationId(defaultIsolationId?.applyValue({ args0 -> args0 }))
            .dnsServers(dnsServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .driverVersion(driverVersion?.applyValue({ args0 -> args0 }))
            .interfaceDescription(interfaceDescription?.applyValue({ args0 -> args0 }))
            .ip4Address(ip4Address?.applyValue({ args0 -> args0 }))
            .subnetMask(subnetMask?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NicDetailArgs].
 */
@PulumiTagMarker
public class NicDetailArgsBuilder internal constructor() {
    private var adapterName: Output<String>? = null

    private var componentId: Output<String>? = null

    private var defaultGateway: Output<String>? = null

    private var defaultIsolationId: Output<String>? = null

    private var dnsServers: Output<List<String>>? = null

    private var driverVersion: Output<String>? = null

    private var interfaceDescription: Output<String>? = null

    private var ip4Address: Output<String>? = null

    private var subnetMask: Output<String>? = null

    /**
     * @param value Adapter Name of NIC
     */
    @JvmName("ynccrfukinbaukjf")
    public suspend fun adapterName(`value`: Output<String>) {
        this.adapterName = value
    }

    /**
     * @param value Component Id of NIC
     */
    @JvmName("prxdgywkillvjwtb")
    public suspend fun componentId(`value`: Output<String>) {
        this.componentId = value
    }

    /**
     * @param value Default Gateway of NIC
     */
    @JvmName("eyjgadmwjxriiuta")
    public suspend fun defaultGateway(`value`: Output<String>) {
        this.defaultGateway = value
    }

    /**
     * @param value Default Isolation of Management NIC
     */
    @JvmName("sotrjsbkokpjpbva")
    public suspend fun defaultIsolationId(`value`: Output<String>) {
        this.defaultIsolationId = value
    }

    /**
     * @param value DNS Servers for NIC
     */
    @JvmName("mnwhpgvnrqxscaqm")
    public suspend fun dnsServers(`value`: Output<List<String>>) {
        this.dnsServers = value
    }

    @JvmName("nclfrpejogyhtlmm")
    public suspend fun dnsServers(vararg values: Output<String>) {
        this.dnsServers = Output.all(values.asList())
    }

    /**
     * @param values DNS Servers for NIC
     */
    @JvmName("lobsgasugyhxfibo")
    public suspend fun dnsServers(values: List<Output<String>>) {
        this.dnsServers = Output.all(values)
    }

    /**
     * @param value Driver Version of NIC
     */
    @JvmName("bwujjvjxwpfntbvi")
    public suspend fun driverVersion(`value`: Output<String>) {
        this.driverVersion = value
    }

    /**
     * @param value Interface Description of NIC
     */
    @JvmName("rbuvnoqotsbdxupb")
    public suspend fun interfaceDescription(`value`: Output<String>) {
        this.interfaceDescription = value
    }

    /**
     * @param value Subnet Mask of NIC
     */
    @JvmName("aaqwodfudjjlancm")
    public suspend fun ip4Address(`value`: Output<String>) {
        this.ip4Address = value
    }

    /**
     * @param value Subnet Mask of NIC
     */
    @JvmName("nmufyytcsrjhigbq")
    public suspend fun subnetMask(`value`: Output<String>) {
        this.subnetMask = value
    }

    /**
     * @param value Adapter Name of NIC
     */
    @JvmName("jrrgvkagmdbikmdw")
    public suspend fun adapterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adapterName = mapped
    }

    /**
     * @param value Component Id of NIC
     */
    @JvmName("isfjprbnqwjdiwde")
    public suspend fun componentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentId = mapped
    }

    /**
     * @param value Default Gateway of NIC
     */
    @JvmName("ytsivttnswpptylh")
    public suspend fun defaultGateway(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultGateway = mapped
    }

    /**
     * @param value Default Isolation of Management NIC
     */
    @JvmName("fvfqbrfrfaqrvley")
    public suspend fun defaultIsolationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultIsolationId = mapped
    }

    /**
     * @param value DNS Servers for NIC
     */
    @JvmName("hhqsslqfmgipggon")
    public suspend fun dnsServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param values DNS Servers for NIC
     */
    @JvmName("erhcglakcjaehksf")
    public suspend fun dnsServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param value Driver Version of NIC
     */
    @JvmName("pyhojomlhlwauwcc")
    public suspend fun driverVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.driverVersion = mapped
    }

    /**
     * @param value Interface Description of NIC
     */
    @JvmName("jrbodfeeagkygwwl")
    public suspend fun interfaceDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interfaceDescription = mapped
    }

    /**
     * @param value Subnet Mask of NIC
     */
    @JvmName("vavclwnwriqkeaat")
    public suspend fun ip4Address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ip4Address = mapped
    }

    /**
     * @param value Subnet Mask of NIC
     */
    @JvmName("shciiwjeuexbylpk")
    public suspend fun subnetMask(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetMask = mapped
    }

    internal fun build(): NicDetailArgs = NicDetailArgs(
        adapterName = adapterName ?: throw PulumiNullFieldException("adapterName"),
        componentId = componentId,
        defaultGateway = defaultGateway,
        defaultIsolationId = defaultIsolationId,
        dnsServers = dnsServers,
        driverVersion = driverVersion,
        interfaceDescription = interfaceDescription,
        ip4Address = ip4Address,
        subnetMask = subnetMask,
    )
}
