@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.PhysicalNodesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The PhysicalNodes of a cluster.
 * @property ipv4Address The IPv4 address assigned to each physical server on your Azure Stack HCI cluster.
 * @property name NETBIOS name of each physical server on your Azure Stack HCI cluster.
 */
public data class PhysicalNodesArgs(
    public val ipv4Address: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.PhysicalNodesArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.PhysicalNodesArgs =
        com.pulumi.azurenative.azurestackhci.inputs.PhysicalNodesArgs.builder()
            .ipv4Address(ipv4Address?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PhysicalNodesArgs].
 */
@PulumiTagMarker
public class PhysicalNodesArgsBuilder internal constructor() {
    private var ipv4Address: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The IPv4 address assigned to each physical server on your Azure Stack HCI cluster.
     */
    @JvmName("vacjcrwhhuhxoufu")
    public suspend fun ipv4Address(`value`: Output<String>) {
        this.ipv4Address = value
    }

    /**
     * @param value NETBIOS name of each physical server on your Azure Stack HCI cluster.
     */
    @JvmName("ogxbcprbssycvrwd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The IPv4 address assigned to each physical server on your Azure Stack HCI cluster.
     */
    @JvmName("clvjjrafhqstlcec")
    public suspend fun ipv4Address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4Address = mapped
    }

    /**
     * @param value NETBIOS name of each physical server on your Azure Stack HCI cluster.
     */
    @JvmName("escopoaarmetntmx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): PhysicalNodesArgs = PhysicalNodesArgs(
        ipv4Address = ipv4Address,
        name = name,
    )
}
